/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.util.ds.ui.BaseDialog;
import com.sybase.util.ds.ui.LDAPPage;
import com.sybase.util.ds.ui.ServerDiscoveryPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsDialog
extends BaseDialog
implements ChangeListener,
MouseListener {
    private JTabbedPane _tabbedPane = null;
    private ServerDiscoveryPage _serverDiscoveryPage = null;
    private LDAPPage _ldapPage = null;
    private boolean _retcode;
    private String _filterId;

    public SettingsDialog(JDialog jDialog) {
        super(jDialog);
        this._filterId = "ASE";
    }

    public SettingsDialog(JDialog jDialog, String string) {
        super(jDialog);
        this._filterId = string;
    }

    public boolean create() {
        this._retcode = false;
        this.setVisible(this.createGUI());
        this.destroyUI();
        return this._retcode;
    }

    void destroyUI() {
        this._serverDiscoveryPage = null;
        this._tabbedPane = null;
        super.destroyUI();
    }

    private boolean createGUI() {
        this._tabbedPane = new JTabbedPane();
        this._serverDiscoveryPage = new ServerDiscoveryPage(this._filterId);
        this._serverDiscoveryPage.init(this);
        this._serverDiscoveryPage.setParentDialog(this);
        this._serverDiscoveryPage.enableComponents();
        this._serverDiscoveryPage.serversList.addMouseListener(this);
        this._tabbedPane.addTab(_res.get("SERVER_DISCOVERY"), (Component)((Object)this._serverDiscoveryPage));
        if (this._filterId.equals("ASE")) {
            this._ldapPage = new LDAPPage();
            this._ldapPage.init(this, this);
            this._ldapPage.enableComponents();
            this._tabbedPane.addTab(_res.get("LDAP"), (Component)((Object)this._ldapPage));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this._tabbedPane, "Center");
        super.createUI(jPanel, _res.get("SETTINGS_TITLE"));
        this._okButton.setEnabled(false);
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = this._serverDiscoveryPage.handleMouseClicked(mouseEvent);
        if (bl) {
            this._okButton.setEnabled(this._serverDiscoveryPage.getEnableSave());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._serverDiscoveryPage.addButton || object == this._serverDiscoveryPage.editButton || object == this._serverDiscoveryPage.removeButton || object == this._serverDiscoveryPage.upButton || object == this._serverDiscoveryPage.downButton || object == this._serverDiscoveryPage.filtersButton || object == this._ldapPage.ldapCheckBox) {
            this._serverDiscoveryPage.handleActionPerformed(actionEvent);
            this._ldapPage.handleActionPerformed();
            this._okButton.setEnabled(this._serverDiscoveryPage.getEnableSave() || object == this._ldapPage.ldapCheckBox);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this._ldapPage.timeoutSlider) {
            this._ldapPage.handleStateChanged();
            this._okButton.setEnabled(true);
        }
    }

    void handleOK() {
        this.setEnabled(false);
        this._okButton.setEnabled(false);
        this._cancelButton.setEnabled(false);
        boolean bl = this.saveSettings();
        if (bl) {
            this.setVisible(false);
            this._retcode = true;
        } else {
            this._okButton.setEnabled(true);
            this._cancelButton.setEnabled(true);
            this.setEnabled(true);
            this._retcode = false;
        }
    }

    private boolean saveSettings() {
        this._serverDiscoveryPage.saveSettings();
        this._ldapPage.saveSettings();
        return true;
    }

    void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }
}

