/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.CountersTableModel;
import asemon.MainFrame;
import asemon.SamplingCnt;
import asemon.TableSorter;
import asemon.TabularCntrPanel;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CountersModel {
    private static Logger logger;
    private String name;
    private int typeModel;
    private String sqlRequest = null;
    private TabularCntrPanel tabPanel = null;
    private int idKey1;
    private int idKey2;
    private int idKey3;
    private String[] colsCalcDiff;
    private Vector bitmapColsCalcDiff = null;
    private String[] colsCalcPCT;
    private Vector bitmapColsCalcPCT = null;
    private String filterColName;
    private int filterColId;
    private String filterStringValue;
    private int filterIntValue;
    private double filterDoubleValue;
    private long filterLongValue;
    private CountersTableModel TM = null;
    protected SamplingCnt oldSample = null;
    protected SamplingCnt newSample = null;
    protected SamplingCnt diffData = null;
    protected SamplingCnt chosenData = null;
    protected SamplingCnt dataTM = null;
    private TableSorter sorter;
    private boolean dataInitialized = false;
    private boolean swingRefreshOK;
    public String displayMode;
    private int maxRowSeen;
    private int selectedModelRow = -1;
    private String colNamesToolTipSql = "select ColumnName, Description from monTableColumns where TableName = ''";
    private Hashtable colNamesToolTipTable = new Hashtable();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("asemon.CountersModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public CountersModel(String nm, String sql, TabularCntrPanel tp, int idK1, int idK2, int idK3, String[] ccd, String[] ccp) {
        this.name = nm;
        this.sqlRequest = sql;
        this.tabPanel = tp;
        this.idKey1 = idK1;
        this.idKey2 = idK2;
        this.idKey3 = idK3;
        this.colsCalcDiff = ccd;
        this.colsCalcPCT = ccp;
        this.filterColId = 0;
        this.oldSample = null;
        this.newSample = null;
        this.diffData = null;
        this.chosenData = null;
        this.dataTM = null;
        this.displayMode = "ABS";
        this.maxRowSeen = 0;
        if (tp != null) {
            this.TM = new CountersTableModel(this);
            this.sorter = new TableSorter(this.TM);
            this.tabPanel.dataTable.setModel(this.sorter);
            this.sorter.setTableHeader(this.tabPanel.dataTable.getTableHeader());
            tp.setCounterModel(this);
        }
        this.dataInitialized = false;
        this.swingRefreshOK = true;
    }

    public String getName() {
        return this.name;
    }

    public void setSelectedViewRow(int i) {
        if (i == -1) {
            this.selectedModelRow = -1;
            return;
        }
        this.selectedModelRow = this.sorter.modelIndex(i);
    }

    public int getSelectedViewRow() {
        if (this.selectedModelRow != -1) {
            return this.sorter.viewIndex(this.selectedModelRow);
        }
        return -1;
    }

    public int getSelectedFirstCol() {
        return (Integer)((Vector)this.dataTM.rows.get(this.selectedModelRow)).get(0);
    }

    public synchronized void setColFilter(String colName) {
        if (this.dataTM == null) {
            return;
        }
        this.filterColName = colName;
        this.filterColId = this.dataTM.getColNames().indexOf(colName) + 1;
    }

    public synchronized void setValFilter(String val) {
        this.filterStringValue = val;
        try {
            this.filterIntValue = Integer.parseInt(val);
        }
        catch (Exception e) {
            this.filterIntValue = 0;
        }
        try {
            this.filterDoubleValue = Double.parseDouble(val);
        }
        catch (Exception e) {
            this.filterDoubleValue = 0.0;
        }
        try {
            this.filterLongValue = Long.parseLong(val);
        }
        catch (Exception e) {
            this.filterLongValue = 0L;
        }
    }

    public synchronized Vector getColNames() {
        if (this.dataTM == null) {
            return null;
        }
        return this.dataTM.getColNames();
    }

    private boolean isFiltered(Vector row) {
        if (this.filterStringValue == null || this.filterStringValue.length() == 0) {
            return false;
        }
        if (this.filterColId > 0) {
            Object cell = row.get(this.filterColId - 1);
            if (cell == null) {
                return true;
            }
            String cls = cell.getClass().toString();
            if (cls.equals("class java.lang.String")) {
                return !cell.equals(this.filterStringValue);
            }
            if (cls.equals("class java.lang.Integer")) {
                return (Integer)cell < this.filterIntValue;
            }
            if (cls.equals("class java.lang.Double")) {
                return (Double)cell < this.filterDoubleValue;
            }
            if (cls.equals("class java.lang.Long")) {
                return (Long)cell < this.filterLongValue;
            }
            if (cls.equals("class java.math.BigDecimal")) {
                return ((BigDecimal)cell).doubleValue() < this.filterDoubleValue;
            }
        }
        return false;
    }

    public boolean showDelta() {
        return this.displayMode.equals("INT");
    }

    public boolean isDeltaCalculatedColumn(int index) {
        return (Integer)this.bitmapColsCalcDiff.get(index) == 1;
    }

    public boolean isPctColumn(int index) {
        return (Integer)this.bitmapColsCalcPCT.get(index) == 1;
    }

    private void computeRates() {
        if (this.name.equals("CMdeviceActivity")) {
            this.computeAvgServ();
        }
        if (this.name.equals("CMengineActivity")) {
            this.computeCpuUsage();
        }
    }

    private void computeCpuUsage() {
        int CPUTimeId = 0;
        int SystemCPUTimeId = 0;
        int UserCPUTimeId = 0;
        int IdleCPUTimeId = 0;
        Vector colNames = this.diffData.getColNames();
        if (colNames == null) {
            return;
        }
        int colId = 0;
        while (colId < colNames.size()) {
            String colName = (String)colNames.get(colId);
            if (colName.equals("CPUTime")) {
                CPUTimeId = colId;
            }
            if (colName.equals("SystemCPUTime")) {
                SystemCPUTimeId = colId;
            }
            if (colName.equals("UserCPUTime")) {
                UserCPUTimeId = colId;
            }
            if (colName.equals("IdleCPUTime")) {
                IdleCPUTimeId = colId;
            }
            ++colId;
        }
        int rowId = 0;
        while (rowId < this.diffData.nbRows) {
            Vector row = (Vector)this.diffData.rows.get(rowId);
            int CPUTime = ((Number)row.get(CPUTimeId)).intValue();
            int SystemCPUTime = ((Number)row.get(SystemCPUTimeId)).intValue();
            int UserCPUTime = ((Number)row.get(UserCPUTimeId)).intValue();
            int IdleCPUTime = ((Number)row.get(IdleCPUTimeId)).intValue();
            System.out.println("----CPUTime = " + CPUTime + ", SystemCPUTime = " + SystemCPUTime + ", UserCPUTime = " + UserCPUTime + ", IdleCPUTime = " + IdleCPUTime);
            BigDecimal calcCPUTime = new BigDecimal(1.0 * (double)(SystemCPUTime + UserCPUTime) / (double)CPUTime * 100.0).setScale(1, 6);
            BigDecimal calcSystemCPUTime = new BigDecimal(1.0 * (double)SystemCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
            BigDecimal calcUserCPUTime = new BigDecimal(1.0 * (double)UserCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
            BigDecimal calcIdleCPUTime = new BigDecimal(1.0 * (double)IdleCPUTime / (double)CPUTime * 100.0).setScale(1, 6);
            System.out.println("++++CPUTime = " + calcCPUTime + ", SystemCPUTime = " + calcSystemCPUTime + ", UserCPUTime = " + calcUserCPUTime + ", IdleCPUTime = " + calcIdleCPUTime);
            row.set(CPUTimeId, calcCPUTime);
            row.set(SystemCPUTimeId, calcSystemCPUTime);
            row.set(UserCPUTimeId, calcUserCPUTime);
            row.set(IdleCPUTimeId, calcIdleCPUTime);
            ++rowId;
        }
    }

    private void computeAvgServ() {
        int ReadsColId = 0;
        int APFReadsColId = 0;
        int WritesColId = 0;
        int IOTimeColId = 0;
        int AvgServ_msColId = 0;
        Vector colNames = this.diffData.getColNames();
        if (colNames == null) {
            return;
        }
        int colId = 0;
        while (colId < colNames.size()) {
            String colName = (String)colNames.get(colId);
            if (colName.equals("Reads")) {
                ReadsColId = colId;
            }
            if (colName.equals("APFReads")) {
                APFReadsColId = colId;
            }
            if (colName.equals("Writes")) {
                WritesColId = colId;
            }
            if (colName.equals("IOTime")) {
                IOTimeColId = colId;
            }
            if (colName.equals("AvgServ_ms")) {
                AvgServ_msColId = colId;
            }
            ++colId;
        }
        int rowId = 0;
        while (rowId < this.diffData.nbRows) {
            Vector row = (Vector)this.diffData.rows.get(rowId);
            int Reads = (Integer)row.get(ReadsColId);
            int APFReads = (Integer)row.get(APFReadsColId);
            int Writes = (Integer)row.get(WritesColId);
            int IOTime = (Integer)row.get(IOTimeColId);
            int totIo = Reads + Writes;
            if (totIo != 0) {
                double AvgServ_ms = IOTime / totIo;
                row.set(AvgServ_msColId, new Double(AvgServ_ms));
            } else {
                row.set(AvgServ_msColId, null);
            }
            ++rowId;
        }
    }

    public synchronized void refreshCM() throws Exception {
        int j;
        boolean found;
        String colname;
        int i;
        Vector colNames;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering refreshCM() method for " + this.name));
        }
        if (!this.swingRefreshOK) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exit refreshCM() method for " + this.name + ". Swingrefresh already processing."));
            }
            return;
        }
        if (MainFrame.dbConnection == null) {
            return;
        }
        this.newSample = new SamplingCnt();
        if (!this.newSample.getCnt(MainFrame.dbConnection, this.sqlRequest, this.idKey1, this.idKey2, this.idKey3)) {
            return;
        }
        if (this.bitmapColsCalcDiff == null) {
            this.bitmapColsCalcDiff = new Vector();
            colNames = this.newSample.getColNames();
            i = 0;
            while (i < colNames.size()) {
                colname = (String)colNames.get(i);
                found = false;
                j = 0;
                while (j < this.colsCalcDiff.length) {
                    if (colname.equals(this.colsCalcDiff[j])) {
                        found = true;
                    }
                    ++j;
                }
                if (found) {
                    this.bitmapColsCalcDiff.add(new Integer(1));
                } else {
                    this.bitmapColsCalcDiff.add(new Integer(0));
                }
                ++i;
            }
        }
        if (this.bitmapColsCalcPCT == null) {
            this.bitmapColsCalcPCT = new Vector();
            colNames = this.newSample.getColNames();
            i = 0;
            while (i < colNames.size()) {
                colname = (String)colNames.get(i);
                found = false;
                j = 0;
                while (j < this.colsCalcPCT.length) {
                    if (colname.equals(this.colsCalcPCT[j])) {
                        found = true;
                    }
                    ++j;
                }
                if (found) {
                    this.bitmapColsCalcPCT.add(new Integer(1));
                } else {
                    this.bitmapColsCalcPCT.add(new Integer(0));
                }
                ++i;
            }
        }
        if (this.oldSample != null) {
            this.diffData = SamplingCnt.computeDiffCnt(this.oldSample, this.newSample, this.idKey1, this.idKey2, this.idKey3, this.bitmapColsCalcDiff);
        }
        if (this.diffData == null) {
            this.dataTM = this.newSample;
            this.maxRowSeen = this.newSample.nbRows;
            if (this.TM != null) {
                this.setupTM();
            }
        } else {
            this.computeRates();
            this.dataInitialized = true;
            if (this.TM != null) {
                this.updateTM();
            }
        }
        this.oldSample = this.newSample;
    }

    private void setupTM() {
        Runnable setupTM_inSwingThread = new Runnable(){

            public void run() {
                CountersModel.this.setupTM_code();
            }
        };
        this.swingRefreshOK = false;
        SwingUtilities.invokeLater(setupTM_inSwingThread);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupTM_code() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Entering setupTM_code() method for " + this.name + " maxrow=" + this.maxRowSeen));
            }
            this.TM.setDataVector(this.dataTM.rows, this.dataTM.colNames);
            this.sorter.setTableModel(this.TM);
            if (this.tabPanel.filterColField.getItemCount() == 0) {
                Vector cols = this.dataTM.getColNames();
                this.tabPanel.filterColField.addItem("<none>");
                int i = 0;
                while (true) {
                    if (i >= cols.size()) {
                        this.setColFilter("");
                        break;
                    }
                    this.tabPanel.filterColField.addItem(cols.get(i));
                    ++i;
                }
            }
            this.tabPanel.absDateTxt.setText(MainFrame.summaryPanel.CountersCleared.getText());
            this.tabPanel.intDateTxt.setText(this.dataTM.samplingTime.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Leaving setupTM_code() method for " + this.name));
            }
            if (this.getName().equals("CMprocActivity")) {
                this.tabPanel.dataTable.setToolTipText("Double-click a row to get the details");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.swingRefreshOK = true;
            this.tabPanel.calcColumnWidths();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.swingRefreshOK = true;
            this.tabPanel.calcColumnWidths();
            return;
        }
    }

    public synchronized void updateTM() {
        Runnable updateTM_inSwingThread = new Runnable(){

            public void run() {
                CountersModel.this.updateTM_code();
            }
        };
        if (this.dataInitialized && this.isSwingRefreshOK()) {
            this.swingRefreshOK = false;
            SwingUtilities.invokeLater(updateTM_inSwingThread);
        } else {
            MainFrame.statusFld.setText("Wait...");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTM_code() {
        key = new String("");
        val = null;
        if (CountersModel.logger.isDebugEnabled()) {
            CountersModel.logger.debug((Object)("Entering updateTM_code() method for " + this.name));
        }
        if (this.dataTM == null) {
            System.out.println("updateTM_code : data is null");
            return;
        }
        if (this.idKey1 == 0) {
            return;
        }
        try {
            this.tabPanel.absDateTxt.setText(MainFrame.summaryPanel.CountersCleared.getText());
            this.tabPanel.intDateTxt.setText(this.newSample.samplingTime.toString());
            if (this.diffData != null) {
                this.tabPanel.intervalTxt.setText(Integer.toString((int)this.diffData.interval));
            }
            this.chosenData = this.displayMode.equals("INT") != false ? this.diffData : this.newSample;
            this.dataTM.samplingTime = this.chosenData.samplingTime;
            this.dataTM.interval = this.chosenData.interval;
            rowInserted = false;
            newRowId = 0;
            while (newRowId < this.chosenData.nbRows) {
                block32: {
                    block31: {
                        newRow = (Vector)this.chosenData.rows.get(newRowId);
                        newRowIsFiltered = this.isFiltered(newRow);
                        key = newRow.get(this.idKey1 - 1).toString();
                        if (this.idKey2 != 0) {
                            key = key.concat(newRow.get(this.idKey2 - 1).toString());
                        }
                        if (this.idKey3 != 0) {
                            key = key.concat(newRow.get(this.idKey3 - 1).toString());
                        }
                        if ((oldRowId = (r = (Integer)this.dataTM.keys.get(key)) != null ? r : -1) == -1) break block31;
                        oldRow = (Vector)this.dataTM.rows.get(oldRowId);
                        i = 1;
                        if (true) ** GOTO lbl61
                    }
                    if (!this.isFiltered(newRow)) {
                        key = newRow.get(this.idKey1 - 1).toString();
                        if (this.idKey2 != 0) {
                            key = key.concat(newRow.get(this.idKey2 - 1).toString());
                        }
                        if (this.idKey3 != 0) {
                            key = key.concat(newRow.get(this.idKey3 - 1).toString());
                        }
                        this.dataTM.keys.put(key, new Integer(this.dataTM.nbRows));
                        newRowClone = (Vector)newRow.clone();
                        this.TM.addRow(newRowClone);
                        ++this.dataTM.nbRows;
                        this.TM.setRowCount(this.dataTM.nbRows);
                        rowInserted = true;
                    }
                    break block32;
                    do {
                        if (i != this.idKey1 && i != this.idKey2 && i != this.idKey3) {
                            oldVal = oldRow.get(i - 1);
                            newVal = newRow.get(i - 1);
                            if (oldVal == null) {
                                if (newVal != null) {
                                    oldRow.setElementAt(newVal, i - 1);
                                }
                            } else if (!oldVal.equals(newVal)) {
                                if (newRowIsFiltered) {
                                    oldRow.setElementAt(newVal, i - 1);
                                } else {
                                    this.TM.setValueAt(newVal, oldRowId, i - 1);
                                }
                            }
                        }
                        ++i;
lbl61:
                        // 2 sources

                    } while (i <= this.dataTM.nbCols);
                }
                ++newRowId;
            }
            rowdeleted = false;
            oldRowId = this.dataTM.nbRows - 1;
            while (oldRowId >= 0) {
                oldRow = (Vector)this.dataTM.rows.get(oldRowId);
                oldRowIsFiltered = this.isFiltered(oldRow);
                key = oldRow.get(this.idKey1 - 1).toString();
                if (this.idKey2 != 0) {
                    key = key.concat(oldRow.get(this.idKey2 - 1).toString());
                }
                if (this.idKey3 != 0) {
                    key = key.concat(oldRow.get(this.idKey3 - 1).toString());
                }
                if ((r = (Integer)this.chosenData.keys.get(key)) == null || oldRowIsFiltered) {
                    this.TM.removeRow(oldRowId);
                    --this.dataTM.nbRows;
                    rowdeleted = true;
                    this.TM.setRowCount(this.dataTM.nbRows);
                }
                --oldRowId;
            }
            if (rowdeleted) {
                this.dataTM.keys = new Hashtable<K, V>();
                i = 0;
                while (i < this.dataTM.nbRows) {
                    oldRow = (Vector)this.dataTM.rows.get(i);
                    key = oldRow.get(this.idKey1 - 1).toString();
                    if (this.idKey2 != 0) {
                        key = key.concat(oldRow.get(this.idKey2 - 1).toString());
                    }
                    if (this.idKey3 != 0) {
                        key = key.concat(oldRow.get(this.idKey3 - 1).toString());
                    }
                    this.dataTM.keys.put(key, new Integer(i));
                    ++i;
                }
            }
        }
        catch (Throwable var14_14) {
            var13_15 = null;
            this.swingRefreshOK = true;
            if (this.maxRowSeen < this.dataTM.nbRows) {
                this.maxRowSeen = this.dataTM.nbRows;
                this.sorter.setTableModel(this.TM);
            }
            this.tabPanel.calcColumnWidths();
            throw var14_14;
        }
        {
            var13_16 = null;
            this.swingRefreshOK = true;
            if (this.maxRowSeen < this.dataTM.nbRows) {
                this.maxRowSeen = this.dataTM.nbRows;
                this.sorter.setTableModel(this.TM);
            }
            this.tabPanel.calcColumnWidths();
            return;
        }
    }

    public synchronized void clearCM() {
        Runnable clearCM_inSwingThread = new Runnable(){

            public void run() {
                CountersModel.this.clearCM_code();
            }
        };
        this.swingRefreshOK = false;
        SwingUtilities.invokeLater(clearCM_inSwingThread);
    }

    private void clearCM_code() {
        if (this.dataTM != null) {
            int oldRowId = this.dataTM.nbRows - 1;
            while (oldRowId >= 0) {
                this.dataTM.rows.remove(oldRowId);
                --this.dataTM.nbRows;
                if (this.TM != null) {
                    this.TM.fireTableRowsDeleted(oldRowId, oldRowId);
                }
                --oldRowId;
            }
        }
        this.filterColName = null;
        this.filterColId = 0;
        this.filterStringValue = null;
        this.oldSample = null;
        this.newSample = null;
        this.diffData = null;
        this.dataTM = null;
        this.chosenData = null;
        this.displayMode = "ABS";
        this.swingRefreshOK = true;
        this.dataInitialized = false;
        this.maxRowSeen = 0;
        this.selectedModelRow = -1;
        if (this.tabPanel != null) {
            this.tabPanel.absDateTxt.setText("");
            this.tabPanel.intDateTxt.setText("");
            this.tabPanel.intervalTxt.setText("");
            this.tabPanel.RBAbsolute.setSelected(true);
        }
    }

    public synchronized Timestamp getTimestamp() {
        if (this.diffData == null) {
            return null;
        }
        return this.diffData.samplingTime;
    }

    public synchronized int size() {
        return this.diffData.rows.size();
    }

    public synchronized Double getValueAsDouble(int rowId, String colname) {
        Object o = this.getValue(rowId, colname);
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        return new Double(Double.parseDouble(o.toString()));
    }

    public synchronized Object getValue(int rowId, String colname) {
        int idCol = this.diffData.getColNames().indexOf(colname);
        if (idCol == -1) {
            System.out.println("getValue: Cant find the column '" + colname + "'.");
            return null;
        }
        if (this.diffData.rows.size() <= rowId) {
            return null;
        }
        return ((Vector)this.diffData.rows.get(rowId)).get(idCol);
    }

    public synchronized Double getMaxValue(String colname) {
        if (this.diffData == null) {
            return null;
        }
        int idCol = this.diffData.getColNames().indexOf(colname);
        if (idCol == -1) {
            System.out.println("getMaxValue: Cant find the column '" + colname + "'.");
            return null;
        }
        if (this.diffData.rows.size() == 0) {
            return null;
        }
        double maxResult = 0.0;
        double result = 0.0;
        int i = 0;
        while (i < this.diffData.rows.size()) {
            Object o = ((Vector)this.diffData.rows.get(i)).get(idCol);
            if (o != null) {
                if (o instanceof Number) {
                    System.out.println("Colname='" + colname + "', Number: " + ((Number)o).doubleValue());
                    result = ((Number)o).doubleValue();
                } else {
                    System.out.println("Colname='" + colname + "', toString(): " + o.toString());
                    result = Double.parseDouble(o.toString());
                }
                if (result > maxResult) {
                    maxResult = result;
                }
            }
            ++i;
        }
        return new Double(maxResult);
    }

    public synchronized Double getSumValuePCT(String colname) {
        if (this.diffData == null) {
            return null;
        }
        int idCol = this.diffData.getColNames().indexOf(colname);
        if (idCol == -1) {
            System.out.println("getSumValuePCT: Cant find the column '" + colname + "'.");
            return null;
        }
        if (this.diffData.rows.size() == 0) {
            return null;
        }
        double result = 0.0;
        int i = 0;
        while (i < this.diffData.rows.size()) {
            Object o = ((Vector)this.diffData.rows.get(i)).get(idCol);
            if (o instanceof Long) {
                System.out.println("Colname='" + colname + "', Long: " + (Long)o);
                result += (double)((Long)o).longValue();
            } else if (o instanceof Double) {
                System.out.println("Colname='" + colname + "', Double: " + (Double)o);
                result += ((Double)o).doubleValue();
            } else {
                System.out.println("Colname='" + colname + "', toString(): " + o.toString());
                result += Double.parseDouble(o.toString());
            }
            ++i;
        }
        return new Double(result);
    }

    public synchronized Double getAvgValuePCT(String colname) {
        Double sum = this.getSumValuePCT(colname);
        if (sum == null) {
            return null;
        }
        return new Double(sum / (double)this.diffData.rows.size());
    }

    public synchronized Double getValue(String keyVal, String colname) {
        if (this.diffData == null) {
            return null;
        }
        int i = 0;
        while (i < this.diffData.nbRows) {
            Vector row = (Vector)this.diffData.rows.get(i);
            if (row.get(0).equals(keyVal)) {
                Object o = this.getValue(i, colname);
                if (o instanceof Double) {
                    return (Double)o;
                }
                return new Double(o.toString());
            }
            ++i;
        }
        return null;
    }

    public boolean isSwingRefreshOK() {
        return this.swingRefreshOK;
    }

    public boolean isDataInitialized() {
        return this.dataInitialized;
    }
}

