/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.CountersModel;
import asemon.MainFrame;
import asemon.SummaryPanel;
import java.awt.Component;
import java.util.Date;
import org.jfree.data.SeriesException;

public class GetCounters
extends Thread {
    private static boolean refreshCntr = false;
    private static boolean refreshing = false;
    public static CountersModel CMObjActivity;
    public static CountersModel CMprocActivity;
    public static CountersModel CMcacheActivity;
    public static CountersModel CMpoolActivity;
    public static CountersModel CMdeviceActivity;
    public static CountersModel CMsyswaitActivity;
    public static CountersModel CMengineActivity;
    public static CountersModel CMIOQueueActivity;
    public static CountersModel CMcachedProcs;
    public static CountersModel CMcachedObjects;
    boolean firstTime = true;

    public GetCounters() {
        String[] colsCalcDiff_CMObjActivity = new String[]{"LogicalReads", "PhysicalReads", "APFReads", "PagesRead", "PhysicalWrites", "PagesWritten", "UsedCount", "RowsInserted", "RowsDeleted", "RowsUpdated", "Operations", "LockRequests", "LockWaits"};
        String[] colsCalcPCT_CMObjActivity = new String[]{};
        CMObjActivity = new CountersModel("CMObjActivity", "select dbname=db_name(A.DBID),objname=object_name(A.ObjectID, A.DBID),A.IndexID, LogicalReads, PhysicalReads, APFReads, PagesRead, PhysicalWrites, PagesWritten, UsedCount, RowsInserted, RowsDeleted, RowsUpdated, Operations, LockRequests=isnull(LockRequests,0), LockWaits=isnull(LockWaits,0) from monOpenObjectActivity A where UsedCount > 0 order by 1,2,3", MainFrame.objActPanel, 1, 2, 3, colsCalcDiff_CMObjActivity, colsCalcPCT_CMObjActivity);
        String[] colsCalcDiff_CMprocActivity = new String[]{"CPUTime", "WaitTime", "LogicalReads", "PhysicalReads", "PagesRead", "PhysicalWrites", "PagesWritten", "TableAccesses", "IndexAccesses", "TempDbObjects", "ULCBytesWritten", "ULCFlushes", "ULCFlushFull", "Transactions", "Commits", "Rollbacks", "PacketsSent", "PacketsReceived", "BytesSent", "BytesReceived"};
        String[] colsCalcPCT_CMprocActivity = new String[]{};
        CMprocActivity = new CountersModel("CMprocActivity", "select P.kpid, P.spid, program_name=convert(varchar,P.program_name), dbname=db_name(P.dbid), login=suser_name(P.suid), status, cmd, procName = object_name(P.id, P.dbid), stmtnum, linenum, blocked, time_blocked, CPUTime, WaitTime, LogicalReads, PhysicalReads, PagesRead, PhysicalWrites, PagesWritten, ScanPgs =  TableAccesses, IdxPgs = IndexAccesses, TmpTbl = TempDbObjects, UlcBytWrite =  ULCBytesWritten, UlcFlush = ULCFlushes, ULCFlushFull, Transactions, Commits, Rollbacks, PacketsSent, PacketsReceived, BytesSent, BytesReceived from sysprocesses P , monProcessActivity A, monProcessNetIO N where P.kpid = A.KPID   and P.kpid = N.KPID", MainFrame.procActPanel, 1, 2, 0, colsCalcDiff_CMprocActivity, colsCalcPCT_CMprocActivity);
        String[] colsCalcDiff_CMcacheActivity = new String[]{"CacheSearches", "PhysicalReads", "LogicalReads", "PhysicalWrites", "Stalls"};
        String[] colsCalcPCT_CMcacheActivity = new String[]{};
        CMcacheActivity = new CountersModel("CMcacheActivity", "select CacheName, CacheSearches, PhysicalReads, LogicalReads, PhysicalWrites, Stalls  from monDataCache order by 1", MainFrame.cacheActPanel, 1, 0, 0, colsCalcDiff_CMcacheActivity, colsCalcPCT_CMcacheActivity);
        String[] colsCalcDiff_CMpoolActivity = new String[]{"PagesRead", "PhysicalReads", "Stalls", "PagesTouched", "BuffersToMRU", "BuffersToLRU"};
        String[] colsCalcPCT_CMpoolActivity = new String[]{};
        CMpoolActivity = new CountersModel("CMpoolActivity", "select CacheName, IOBufferSize, AllocatedKB, PagesRead, PhysicalReads, Stalls, PagesTouched, BuffersToMRU, BuffersToLRU from monCachePool order by 1,2,3", MainFrame.poolActPanel, 1, 2, 3, colsCalcDiff_CMpoolActivity, colsCalcPCT_CMpoolActivity);
        String[] colsCalcDiff_CMdeviceActivity = new String[]{"Reads", "APFReads", "Writes", "DevSemaphoreRequests", "DevSemaphoreWaits", "IOTime"};
        String[] colsCalcPCT_CMdeviceActivity = new String[]{};
        CMdeviceActivity = new CountersModel("CMdeviceActivity", "select LogicalName, Reads, APFReads, Writes, DevSemaphoreRequests, DevSemaphoreWaits, IOTime, AvgServ_ms=case when Reads+APFReads+Writes>0 then convert(numeric(18,2),IOTime/convert(numeric(18,0),Reads+APFReads+Writes)) else null end from monDeviceIO", MainFrame.deviceActPanel, 1, 0, 0, colsCalcDiff_CMdeviceActivity, colsCalcPCT_CMdeviceActivity);
        String[] colsCalcDiff_CMsyswaitActivity = new String[]{"WaitTime", "Waits"};
        String[] colsCalcPCT_CMsyswaitActivity = new String[]{};
        CMsyswaitActivity = new CountersModel("CMsyswaitActivity", "select Class=C.Description,Event=I.Description,W.WaitEventID,WaitTime,Waits from monSysWaits W, monWaitEventInfo I, monWaitClassInfo C where W.WaitEventID=I.WaitEventID and I.WaitClassID=C.WaitClassID order by 1,2,3", MainFrame.syswaitActPanel, 1, 2, 3, colsCalcDiff_CMsyswaitActivity, colsCalcPCT_CMsyswaitActivity);
        String[] colsCalcDiff_CMengineActivity = new String[]{"CPUTime", "SystemCPUTime", "UserCPUTime", "IdleCPUTime", "Yields", "Connections", "DiskIOChecks", "DiskIOPolled", "DiskIOCompleted", "ContextSwitches", "HkgcMaxQSize", "HkgcPendingItems", "HkgcHWMItems", "HkgcOverflows"};
        String[] colsCalcPCT_CMengineActivity = new String[]{"CPUTime", "SystemCPUTime", "UserCPUTime", "IdleCPUTime"};
        CMengineActivity = new CountersModel("CMengineActivity", "select EngineNumber,CurrentKPID,PreviousKPID, CPUTime, SystemCPUTime, UserCPUTime, IdleCPUTime, Yields, Connections, DiskIOChecks, DiskIOPolled, DiskIOCompleted, ContextSwitches, HkgcMaxQSize, HkgcPendingItems, HkgcHWMItems, HkgcOverflows, ProcessesAffinitied, Status, StartTime, StopTime, AffinitiedToCPU, OSPID from monEngine order by 1", MainFrame.engineActPanel, 1, 0, 0, colsCalcDiff_CMengineActivity, colsCalcPCT_CMengineActivity);
        String[] colsCalcDiff_CMIOQueueActivity = new String[]{"IOs", "IOTime"};
        String[] colsCalcPCT_CMIOQueueActivity = new String[]{};
        CMIOQueueActivity = new CountersModel("CMIOQueueActivity ", "select IOType,IOs=sum(convert(numeric(18,0),IOs)), IOTime=sum(convert(numeric(18,0),IOTime)) from monIOQueue group by IOType order by 1", MainFrame.ioActPanel, 1, 0, 0, colsCalcDiff_CMIOQueueActivity, colsCalcPCT_CMIOQueueActivity);
        String[] colsCalcDiff_CMcachedProcs = new String[]{};
        String[] colsCalcPCT_CMcachedProcs = new String[]{};
        CMcachedProcs = new CountersModel("CMcacheProcs ", "select PlanID,DBName, ObjectName, ObjectType, MemUsageKB, CompileDate from monCachedProcedures order by 2,3,4", MainFrame.cachedProcsPanel, 1, 0, 0, colsCalcDiff_CMcachedProcs, colsCalcPCT_CMcachedProcs);
        String[] colsCalcDiff_CMcachedObjects = new String[]{};
        String[] colsCalcPCT_CMcachedObjects = new String[]{};
        CMcachedObjects = new CountersModel("CMcachedObjects ", "select DBID, ObjectID, IndexID, DBName,  ObjectName, ObjectType, CachedKB, CacheName from monCachedObject", MainFrame.cachedObjectsPanel, 1, 2, 3, colsCalcDiff_CMcachedObjects, colsCalcPCT_CMcachedObjects);
    }

    public void stopRefresh() {
        refreshCntr = false;
    }

    public void startRefresh() {
        refreshCntr = true;
    }

    public static boolean isRefreshing() {
        return refreshing;
    }

    public static void setRefreshing(boolean s) {
        refreshing = s;
    }

    public void clearComponents() {
        if (!GetCounters.isRefreshing()) {
            MainFrame.summaryPanel.clearSummaryData();
            CMObjActivity.clearCM();
            CMprocActivity.clearCM();
            CMcacheActivity.clearCM();
            CMpoolActivity.clearCM();
            CMdeviceActivity.clearCM();
            CMsyswaitActivity.clearCM();
            CMengineActivity.clearCM();
            CMIOQueueActivity.clearCM();
            CMcachedProcs.clearCM();
            CMcachedObjects.clearCM();
            SummaryPanel.trendCPU.clearGraph();
            SummaryPanel.trendOrdinaryIO.clearGraph();
            SummaryPanel.trendTempdbIO.clearGraph();
            MainFrame.statusFld.setText("");
        }
    }

    public void run() {
        int loopCounter = 0;
        Double[] cpuArray = new Double[3];
        Double[] ordIoArray = new Double[2];
        Double[] tempdbIoArray = new Double[2];
        Double[] srvcTimeArray = new Double[2];
        while (true) {
            ++loopCounter;
            try {
                if (!this.firstTime) {
                    Thread.sleep(MainFrame.refreshInterval * 1000);
                }
                this.firstTime = false;
                if (!refreshCntr || MainFrame.dbConnection == null) continue;
                refreshing = true;
                Component comp = MainFrame.mainTabbedPane.getSelectedComponent();
                MainFrame.statusFld.setText("Refreshing...");
                MainFrame.summaryPanel.getSummaryData(MainFrame.dbConnection);
                if (comp.equals(MainFrame.objActPanel) && CMObjActivity.isSwingRefreshOK()) {
                    CMObjActivity.refreshCM();
                }
                if (comp.equals(MainFrame.procActPanel) && CMprocActivity.isSwingRefreshOK()) {
                    CMprocActivity.refreshCM();
                }
                if (comp.equals(MainFrame.cacheActPanel) && CMcacheActivity.isSwingRefreshOK()) {
                    CMcacheActivity.refreshCM();
                }
                if (comp.equals(MainFrame.poolActPanel) && CMpoolActivity.isSwingRefreshOK()) {
                    CMpoolActivity.refreshCM();
                }
                if (CMdeviceActivity.isSwingRefreshOK()) {
                    CMdeviceActivity.refreshCM();
                }
                if (comp.equals(MainFrame.syswaitActPanel) && CMsyswaitActivity.isSwingRefreshOK()) {
                    CMsyswaitActivity.refreshCM();
                }
                if (CMengineActivity.isSwingRefreshOK()) {
                    CMengineActivity.refreshCM();
                }
                if (CMIOQueueActivity.isSwingRefreshOK()) {
                    CMIOQueueActivity.refreshCM();
                }
                if (comp.equals(MainFrame.cachedProcsPanel) && CMcachedProcs.isSwingRefreshOK()) {
                    CMcachedProcs.refreshCM();
                }
                if (comp.equals(MainFrame.cachedObjectsPanel)) {
                    CMcachedObjects.refreshCM();
                }
                MainFrame.statusFld.setText("");
                cpuArray[0] = CMengineActivity.getAvgValuePCT("CPUTime");
                cpuArray[1] = CMengineActivity.getAvgValuePCT("SystemCPUTime");
                cpuArray[2] = CMengineActivity.getAvgValuePCT("UserCPUTime");
                SummaryPanel.trendCPU.addPoint((Date)CMengineActivity.getTimestamp(), cpuArray);
                Double[] engCpuArray = new Double[CMengineActivity.size()];
                String[] engNumArray = new String[engCpuArray.length];
                int i = 0;
                while (i < engCpuArray.length) {
                    engCpuArray[i] = CMengineActivity.getValueAsDouble(i, "CPUTime");
                    engNumArray[i] = "eng-" + i;
                    ++i;
                }
                SummaryPanel.trendEngCPU.addPoint(CMengineActivity.getTimestamp(), engCpuArray, engNumArray);
                ordIoArray[0] = CMIOQueueActivity.getValue("User Log", "IOs");
                ordIoArray[1] = CMIOQueueActivity.getValue("User Data", "IOs");
                SummaryPanel.trendOrdinaryIO.addPoint((Date)CMIOQueueActivity.getTimestamp(), ordIoArray);
                tempdbIoArray[0] = CMIOQueueActivity.getValue("Tempdb Log", "IOs");
                tempdbIoArray[1] = CMIOQueueActivity.getValue("Tempdb Data", "IOs");
                SummaryPanel.trendTempdbIO.addPoint((Date)CMIOQueueActivity.getTimestamp(), tempdbIoArray);
                Double IoNum = CMIOQueueActivity.getSumValuePCT("IOs");
                Double IoTime = CMIOQueueActivity.getSumValuePCT("IOTime");
                double avgIoServiceTime = 0.0;
                if (IoNum > 0.0) {
                    avgIoServiceTime = IoTime / IoNum;
                }
                srvcTimeArray[0] = CMdeviceActivity.getMaxValue("AvgServ_ms");
                srvcTimeArray[1] = new Double(avgIoServiceTime);
                System.out.println("IoNum=" + IoNum + ", IoTime=" + IoTime + ", IoServiceTime=" + avgIoServiceTime + ", Max AvgServ_ms=" + srvcTimeArray[0]);
                SummaryPanel.trendDeviceIo.addPoint((Date)CMdeviceActivity.getTimestamp(), srvcTimeArray);
                refreshing = false;
                continue;
            }
            catch (SeriesException jfsex) {
                refreshing = false;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                refreshing = false;
                continue;
            }
            break;
        }
    }
}

