/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.AboutBox;
import asemon.GetCounters;
import asemon.MessageDialog;
import asemon.OpenConnectionDlg;
import asemon.ParametersDlg;
import asemon.SummaryPanel;
import asemon.TabularCntrPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MainFrame
extends JFrame {
    static Logger logger;
    public static Connection dbConnection;
    public OpenConnectionDlg openConnDlg = new OpenConnectionDlg(this, "Connection", true);
    private ParametersDlg paramDlg = new ParametersDlg(this, "Parameters", true);
    static int refreshInterval;
    public static GetCounters getCnt;
    public static TabularCntrPanel currentPanel;
    public static SummaryPanel summaryPanel;
    public static TabularCntrPanel objActPanel;
    public static TabularCntrPanel procActPanel;
    public static TabularCntrPanel cacheActPanel;
    public static TabularCntrPanel poolActPanel;
    public static TabularCntrPanel deviceActPanel;
    public static TabularCntrPanel ioActPanel;
    public static TabularCntrPanel syswaitActPanel;
    public static TabularCntrPanel engineActPanel;
    public static TabularCntrPanel cachedProcsPanel;
    public static TabularCntrPanel cachedObjectsPanel;
    private JPanel contentPane;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private ImageIcon image1;
    private ImageIcon image2;
    private ImageIcon image3;
    private BorderLayout borderLayout1 = new BorderLayout();
    public static JTabbedPane mainTabbedPane;
    private TitledBorder titledBorder2;
    private JMenuItem connectMenu = new JMenuItem();
    private JMenuItem disconnectMenu = new JMenuItem();
    private TitledBorder titledBorder3;
    private JMenu ViewMenu = new JMenu();
    private JMenuItem RefreshRatemenu = new JMenuItem();
    private JPanel infoPanel = new JPanel();
    public static JLabel serverNameFld;
    private JPanel statusPanel = new JPanel();
    public static JLabel statusFld;
    private BorderLayout borderLayout2 = new BorderLayout();
    private JLabel blankLbl = new JLabel();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("asemon.CountersModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        dbConnection = null;
        refreshInterval = 5;
        currentPanel = null;
        summaryPanel = new SummaryPanel();
        objActPanel = new TabularCntrPanel("Objects Activity");
        procActPanel = new TabularCntrPanel("Process Activity");
        cacheActPanel = new TabularCntrPanel("Data Caches Activity");
        poolActPanel = new TabularCntrPanel("Pools Activity");
        deviceActPanel = new TabularCntrPanel("Devices Activity");
        ioActPanel = new TabularCntrPanel("IO Activity");
        syswaitActPanel = new TabularCntrPanel("Waits");
        engineActPanel = new TabularCntrPanel("Engines");
        cachedProcsPanel = new TabularCntrPanel("Procedure Cache");
        cachedObjectsPanel = new TabularCntrPanel("Objects Cache");
        mainTabbedPane = new JTabbedPane();
        serverNameFld = new JLabel();
        statusFld = new JLabel();
    }

    public MainFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Image img = Toolkit.getDefaultToolkit().getImage(String.valueOf(System.getProperty("ASEMON_HOME")) + "/asemon_icon.gif");
        this.setIconImage(img);
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder2 = new TitledBorder("");
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(747, 536));
        this.setTitle("Asemon");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        mainTabbedPane.setActionMap(null);
        mainTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MainFrame.this.mainTabbedPane_stateChanged(e);
            }
        });
        this.connectMenu.setText("Connect");
        this.connectMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.connectMenu_actionPerformed(e);
            }
        });
        this.disconnectMenu.setText("Disconnect");
        this.disconnectMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.disconnectMenu_actionPerformed(e);
            }
        });
        this.ViewMenu.setText("View");
        this.RefreshRatemenu.setText("RefreshRate");
        this.RefreshRatemenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.RefreshRatemenu_actionPerformed(e);
            }
        });
        this.infoPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.infoPanel.setPreferredSize(new Dimension(50, 21));
        this.infoPanel.setLayout(new BorderLayout());
        serverNameFld.setBorder(BorderFactory.createLoweredBevelBorder());
        serverNameFld.setMaximumSize(new Dimension(200, 20));
        serverNameFld.setPreferredSize(new Dimension(200, 17));
        serverNameFld.setText(" ");
        statusFld.setText(" ");
        statusFld.setPreferredSize(new Dimension(32768, 17));
        statusFld.setMaximumSize(new Dimension(23768, 20));
        statusFld.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusPanel.setLayout(this.borderLayout2);
        this.blankLbl.setText(" ");
        this.jMenuFile.add(this.connectMenu);
        this.jMenuFile.add(this.disconnectMenu);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.ViewMenu);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)mainTabbedPane, "Center");
        this.contentPane.add((Component)this.infoPanel, "South");
        this.infoPanel.add((Component)serverNameFld, "East");
        this.infoPanel.add((Component)this.statusPanel, "Center");
        this.statusPanel.add((Component)statusFld, "Center");
        this.statusPanel.add((Component)this.blankLbl, "East");
        mainTabbedPane.add((Component)summaryPanel, "Summary");
        mainTabbedPane.add((Component)objActPanel, "Objects");
        mainTabbedPane.add((Component)procActPanel, "Process");
        mainTabbedPane.add((Component)cacheActPanel, "DataCaches");
        mainTabbedPane.add((Component)poolActPanel, "Pools");
        mainTabbedPane.add((Component)deviceActPanel, "Devices");
        mainTabbedPane.add((Component)ioActPanel, "IO");
        mainTabbedPane.add((Component)syswaitActPanel, "Waits");
        mainTabbedPane.add((Component)engineActPanel, "Engines");
        mainTabbedPane.add((Component)cachedProcsPanel, "Procedure Cache");
        mainTabbedPane.add((Component)cachedObjectsPanel, "Objects Cache");
        this.ViewMenu.add(this.RefreshRatemenu);
        this.openConnDlg.setLocationRelativeTo(null);
        this.paramDlg.setLocationRelativeTo(null);
        getCnt = new GetCounters();
        getCnt.start();
    }

    public static void terminateConnection() {
        getCnt.stopRefresh();
        while (true) {
            if (!GetCounters.isRefreshing()) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        getCnt.clearComponents();
        try {
            if (dbConnection != null) {
                dbConnection.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Connexion closed");
                }
            }
        }
        catch (SQLException ev) {
            System.out.println("terminateConnection : " + ev);
        }
        dbConnection = null;
        serverNameFld.setText("");
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        AboutBox dlg = new AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            MainFrame.terminateConnection();
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void connectMenu_actionPerformed(ActionEvent e) {
        if (dbConnection != null) {
            MessageDialog msg = new MessageDialog((Frame)this, "Error", "Connection already opened");
            return;
        }
        this.openConnDlg.getPreferredSize();
        this.openConnDlg.setVisible(true);
        dbConnection = this.openConnDlg.getConnection();
        if (dbConnection != null) {
            MainFrame.summaryPanel.serverName.setText(this.openConnDlg.getServerName());
            serverNameFld.setText(this.openConnDlg.getServerName());
            getCnt.startRefresh();
        }
    }

    void disconnectMenu_actionPerformed(ActionEvent e) {
        MainFrame.terminateConnection();
    }

    void RefreshRatemenu_actionPerformed(ActionEvent e) {
        this.paramDlg.getPreferredSize();
        this.paramDlg.setRefreshRateFld(refreshInterval);
        this.paramDlg.setVisible(true);
        refreshInterval = this.paramDlg.getRefreshRateFld();
    }

    void mainTabbedPane_stateChanged(ChangeEvent e) {
        String currentTab = mainTabbedPane.getTitleAt(mainTabbedPane.getSelectedIndex());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("state changed pannel " + currentTab));
        }
        if (currentTab.equals("Objects")) {
            currentPanel = objActPanel;
        }
        if (currentTab.equals("Process")) {
            currentPanel = procActPanel;
        }
        if (currentTab.equals("DataCaches")) {
            currentPanel = cacheActPanel;
        }
        if (currentTab.equals("Pools")) {
            currentPanel = poolActPanel;
        }
        if (currentTab.equals("Devices")) {
            currentPanel = deviceActPanel;
        }
        if (currentTab.equals("IO")) {
            currentPanel = ioActPanel;
        }
        if (currentTab.equals("Waits")) {
            currentPanel = syswaitActPanel;
        }
        if (currentTab.equals("Engines")) {
            currentPanel = engineActPanel;
        }
        if (currentTab.equals("Procedure Cache")) {
            currentPanel = cachedProcsPanel;
        }
        if (currentTab.equals("Objects Cache")) {
            currentPanel = cachedObjectsPanel;
        }
        if (currentPanel != null && !MainFrame.currentPanel.CM.isDataInitialized() && dbConnection != null) {
            statusFld.setText("Wait...");
        }
    }
}

