/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.MessageDialog;
import asemon.XYConstraints;
import asemon.XYLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OpenConnectionDlg
extends JDialog {
    private static Logger logger;
    private static Frame theFrame;
    private Connection conn = null;
    private Vector[] serverList = null;
    private JPanel mainPanel = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private JButton OKButton = new JButton();
    private JButton cancelButton = new JButton();
    private JLabel userNameLbl = new JLabel();
    private JLabel passwordLbl = new JLabel();
    private JLabel serverListLbl = new JLabel();
    private JTextField userNameField = new JTextField();
    private JTextField passwordField = new JPasswordField();
    private JComboBox serverListCB = new JComboBox();
    private JLabel iniFileLabel = new JLabel();
    private JTextField sqliniField = new JTextField();
    private boolean sqliniChanged = false;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTextField portFld = new JTextField();
    private JLabel portLbl = new JLabel();
    private JTextField hostNameFld = new JTextField();
    private JLabel hostNameLbl = new JLabel();
    private JPanel sqliniPanel = new JPanel();
    private XYLayout xYLayout2 = new XYLayout();
    private JPanel hostPortPanel = new JPanel();
    private XYLayout xYLayout3 = new XYLayout();
    private static String usedUserName;
    private static String usedPassword;
    private static String usedHostName;
    private static String usedPort;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("asemon.CountersModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        theFrame = null;
    }

    public OpenConnectionDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        theFrame = frame;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public OpenConnectionDlg() {
        this((Frame)null, "", false);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getServerName() {
        return (String)this.serverListCB.getSelectedItem();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Connection openConnection(String user, String passwd, String host, String port) {
        Connection cnx = null;
        try {
            Class.forName("com.sybase.jdbc2.jdbc.SybDriver").newInstance();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            props.put("JCONNECT_VERSION", "6");
            props.put("USE_METADATA", "FALSE");
            props.put("PACKETSIZE", "512");
            props.put("APPLICATIONNAME", "asemon");
            props.put("CHARSET", "iso_1");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Try getConnection to " + host + ":" + port + " user=" + user));
            }
            cnx = DriverManager.getConnection("jdbc:sybase:Tds:" + host + ":" + port + "/master", props);
            Statement stmt = cnx.createStatement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Verify mon_role");
            }
            ResultSet rs = stmt.executeQuery("sp_activeroles");
            boolean has_mon_role = false;
            while (rs.next()) {
                if (!rs.getString(1).equals("mon_role")) continue;
                has_mon_role = true;
            }
            if (!has_mon_role) {
                MessageDialog msg = new MessageDialog(theFrame, "Error", "You need 'mon_role' to access monitoring tables");
                return null;
            }
            stmt.executeUpdate("use master");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Verify monTables existance");
            }
            rs = stmt.executeQuery("select count(*) from sysobjects where name ='monTables'");
            while (rs.next()) {
                if (rs.getInt(1) != 0) continue;
                MessageDialog msg = new MessageDialog(theFrame, "Error", "Monitoring tables must be installed ( execute 'scripts/installmontables' )");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Verify enable monitoring");
            }
            rs = stmt.executeQuery("sp_configure 'enable monitoring'");
            while (rs.next()) {
                if (rs.getInt(5) != 0) continue;
                MessageDialog msg = new MessageDialog(theFrame, "Error", "Parameter 'enable monitoring' must be set to '1'");
                return null;
            }
            rs = stmt.executeQuery("sp_configure 'wait event timing'");
            while (rs.next()) {
                if (rs.getInt(5) != 0) continue;
                MessageDialog msg = new MessageDialog(theFrame, "Error", "Parameter 'wait event timing' must be set to '1'");
                return null;
            }
            rs = stmt.executeQuery("sp_configure 'per object statistics active'");
            while (rs.next()) {
                if (rs.getInt(5) != 0) continue;
                MessageDialog msg = new MessageDialog(theFrame, "Error", "Parameter 'per object statistics active' must be set to '1'");
                return null;
            }
            if (!logger.isDebugEnabled()) return cnx;
            logger.debug((Object)("Connexion to " + host + ":" + port + " opened"));
            return cnx;
        }
        catch (SQLException ev) {
            MessageDialog msg = new MessageDialog(theFrame, "Error", "openConnection : " + ev);
            return null;
        }
        catch (Exception ev) {
            System.out.println("openConnection : " + ev);
            return null;
        }
    }

    public static Connection getAnotherConnection() {
        if (usedUserName == null || usedPassword == null || usedHostName == null || usedPort == null) {
            return null;
        }
        return OpenConnectionDlg.openConnection(usedUserName, usedPassword, usedHostName, usedPort);
    }

    private Vector[] parseSqlIniFile(String sqliniFile) {
        BufferedReader in;
        String aString = null;
        Vector[] result = null;
        try {
            in = new BufferedReader(new FileReader(sqliniFile));
        }
        catch (Exception e) {
            return null;
        }
        try {
            boolean readnexline = true;
            aString = null;
            block4: while (true) {
                if (readnexline) {
                    aString = in.readLine();
                }
                readnexline = true;
                if (aString != null) {
                    if (aString.length() == 0 || aString.charAt(0) == '#' || aString.charAt(0) != '[') continue;
                    if (result == null) {
                        result = new Vector[]{new Vector(), new Vector(), new Vector()};
                    }
                    StringTokenizer aTokenizer = new StringTokenizer(aString, "[]");
                    result[0].add(aTokenizer.nextToken());
                    boolean foundQuery = false;
                    while (true) {
                        if ((aString = in.readLine()) == null || aString.length() == 0 || aString.charAt(0) == '[') {
                            if (!foundQuery) {
                                result[1].add(new String(""));
                                result[2].add(new String(""));
                            }
                            readnexline = false;
                            continue block4;
                        }
                        aTokenizer = new StringTokenizer(aString, "=,");
                        if (aTokenizer.countTokens() < 2) {
                            readnexline = false;
                            continue block4;
                        }
                        String rowType = aTokenizer.nextToken().toUpperCase();
                        if (rowType.indexOf("QUERY") <= -1) continue;
                        foundQuery = true;
                        aTokenizer.nextToken();
                        result[1].add(aTokenizer.nextToken());
                        if (aTokenizer.hasMoreTokens()) break;
                        System.out.println("sql.ini. Bad format : " + aString);
                        foundQuery = false;
                    }
                    StringTokenizer aTokenizerPort = new StringTokenizer(aTokenizer.nextToken(), " \t");
                    result[2].add(aTokenizerPort.nextToken());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("sql.ini. " + aString + " : " + e);
            e.printStackTrace();
        }
        return result;
    }

    private void loadServerCB() {
        this.serverListCB.removeAllItems();
        this.serverList = this.parseSqlIniFile(this.sqliniField.getText());
        if (this.serverList != null) {
            TreeSet serverListSorted = new TreeSet(this.serverList[0]);
            Iterator it = serverListSorted.iterator();
            while (it.hasNext()) {
                String srv = (String)it.next();
                this.serverListCB.addItem(srv);
            }
        }
        this.sqliniChanged = false;
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.xYLayout1);
        this.mainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.mainPanel.setMaximumSize(new Dimension(325, 375));
        this.mainPanel.setMinimumSize(new Dimension(325, 375));
        this.mainPanel.setNextFocusableComponent(this.userNameField);
        this.mainPanel.setPreferredSize(new Dimension(325, 375));
        this.setModal(true);
        this.setTitle("Connection");
        this.getContentPane().setLayout(this.borderLayout1);
        this.OKButton.setNextFocusableComponent(this.sqliniField);
        this.OKButton.setSelected(true);
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OpenConnectionDlg.this.OKButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OpenConnectionDlg.this.cancelButton_actionPerformed(e);
            }
        });
        this.userNameLbl.setHorizontalAlignment(4);
        this.userNameLbl.setText("Username :");
        this.passwordLbl.setText("Password :");
        this.passwordLbl.setHorizontalAlignment(4);
        this.serverListLbl.setHorizontalAlignment(4);
        this.serverListLbl.setText("Server :");
        this.iniFileLabel.setText("sql.ini file :");
        this.iniFileLabel.setHorizontalAlignment(4);
        this.serverListCB.setNextFocusableComponent(this.hostNameFld);
        this.serverListCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OpenConnectionDlg.this.serverListCB_actionPerformed(e);
            }
        });
        this.userNameField.setNextFocusableComponent(this.passwordField);
        this.passwordField.setNextFocusableComponent(this.OKButton);
        this.sqliniField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OpenConnectionDlg.this.sqliniField_actionPerformed(e);
            }
        });
        this.sqliniField.setNextFocusableComponent(this.serverListCB);
        this.sqliniField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                OpenConnectionDlg.this.sqliniField_keyTyped(e);
            }
        });
        this.sqliniField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                OpenConnectionDlg.this.sqliniField_focusLost(e);
            }
        });
        this.sqliniField.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                OpenConnectionDlg.this.sqliniField_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.portFld.setNextFocusableComponent(this.userNameField);
        this.portLbl.setHorizontalAlignment(4);
        this.portLbl.setText("Port :");
        this.hostNameFld.setNextFocusableComponent(this.portFld);
        this.hostNameLbl.setText("Hostname :");
        this.hostNameLbl.setHorizontalAlignment(4);
        this.sqliniPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.sqliniPanel.setLayout(this.xYLayout2);
        this.hostPortPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.hostPortPanel.setLayout(this.xYLayout3);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.userNameField, new XYConstraints(106, 243, 113, -1));
        this.mainPanel.add((Component)this.passwordLbl, new XYConstraints(22, 266, 75, 25));
        this.mainPanel.add((Component)this.passwordField, new XYConstraints(106, 272, 113, -1));
        this.mainPanel.add((Component)this.userNameLbl, new XYConstraints(22, 237, 75, 25));
        this.mainPanel.add((Component)this.OKButton, new XYConstraints(211, 321, 82, 28));
        this.mainPanel.add((Component)this.cancelButton, new XYConstraints(113, 321, 82, 28));
        this.mainPanel.add((Component)this.sqliniPanel, new XYConstraints(21, 11, 282, 81));
        this.sqliniPanel.add((Component)this.serverListCB, new XYConstraints(83, 43, -1, -1));
        this.sqliniPanel.add((Component)this.serverListLbl, new XYConstraints(30, 45, -1, -1));
        this.sqliniPanel.add((Component)this.iniFileLabel, new XYConstraints(13, 10, -1, -1));
        this.sqliniPanel.add((Component)this.sqliniField, new XYConstraints(83, 8, 162, -1));
        this.mainPanel.add((Component)this.hostPortPanel, new XYConstraints(21, 124, 282, 81));
        this.hostPortPanel.add((Component)this.portFld, new XYConstraints(83, 48, 113, -1));
        this.hostPortPanel.add((Component)this.hostNameLbl, new XYConstraints(-4, 13, 75, 25));
        this.hostPortPanel.add((Component)this.hostNameFld, new XYConstraints(83, 14, 161, -1));
        this.hostPortPanel.add((Component)this.portLbl, new XYConstraints(-4, 47, 75, 25));
        this.sqliniField.setText(String.valueOf(System.getProperty("SYBASE")) + "\\ini\\sql.ini");
        this.loadServerCB();
    }

    void OKButton_actionPerformed(ActionEvent e) {
        int serverId = -1;
        if (this.serverList != null) {
            serverId = this.serverList[0].indexOf(this.serverListCB.getSelectedItem());
        }
        usedUserName = this.userNameField.getText();
        usedPassword = this.passwordField.getText();
        if (serverId == -1) {
            usedHostName = this.hostNameFld.getText();
            usedPort = this.portFld.getText();
        } else {
            usedHostName = (String)this.serverList[1].get(serverId);
            usedPort = (String)this.serverList[2].get(serverId);
        }
        this.conn = OpenConnectionDlg.openConnection(usedUserName, usedPassword, usedHostName, usedPort);
        if (this.conn == null) {
            return;
        }
        this.setVisible(false);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.userNameField.setText("");
        this.passwordField.setText("");
    }

    void sqliniField_actionPerformed(ActionEvent e) {
        if (this.sqliniChanged) {
            this.loadServerCB();
        }
    }

    void sqliniField_inputMethodTextChanged(InputMethodEvent e) {
        this.sqliniChanged = true;
    }

    void sqliniField_focusLost(FocusEvent e) {
        if (this.sqliniChanged) {
            this.loadServerCB();
        }
    }

    void sqliniField_keyTyped(KeyEvent e) {
        this.sqliniChanged = true;
    }

    void serverListCB_actionPerformed(ActionEvent e) {
        int serverId = -1;
        if (this.serverList != null) {
            serverId = this.serverList[0].indexOf(this.serverListCB.getSelectedItem());
        }
        if (serverId != -1) {
            this.hostNameFld.setText((String)this.serverList[1].get(serverId));
            this.portFld.setText((String)this.serverList[2].get(serverId));
        }
    }
}

