/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.Batch;
import asemon.CountersModel;
import asemon.MessageDialog;
import asemon.ProcessDetailFrame;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class RefreshProcess
extends Thread {
    private ProcessDetailFrame pdf;
    private Connection conn;
    private boolean refreshProcessFlag;
    boolean batchCapture = false;
    boolean SQLTextMonitor = false;
    boolean planTextPipe = false;
    boolean planTextPipeMsg = false;
    boolean sqlTextPipe = false;
    boolean sqlTextPipeMsg = false;
    boolean stmtPipe = false;
    boolean stmtPipeMsg = false;
    boolean stmtStat = false;
    boolean procWaitEvents = false;
    boolean has_sa_role = false;
    private Statement stmt;
    private int kpid;
    private int spid;
    private ResultSet rs;
    private int currentBatchID = -1;
    private int previousBatchID = -1;
    private int currentDBID = -1;
    private int currentProcedureID = -1;
    private Vector currentStmtColNames = null;
    private StatementsModel currentStmtModel;
    private boolean currentSMInitialized = false;
    private Vector currentStmt = null;
    private Vector currentStmtRow = null;
    private Batch currentBatch;
    private Vector capturedStmtColNames = null;
    private StatementsModel capturedStmtModel;
    private boolean capturedSMInitialized = false;
    private Vector newStatements = null;
    private int stmtHistoryCnt = 0;
    private int selectedStatement;
    private Hashtable batchHistory;
    private Hashtable plansHistory;
    public CountersModel CMProcObjects;
    public CountersModel CMProcWaits;

    public RefreshProcess(ProcessDetailFrame aPdf, Connection c, int k) {
        this.pdf = aPdf;
        this.conn = c;
        this.kpid = k;
        this.refreshProcessFlag = true;
        this.selectedStatement = -1;
        try {
            this.stmt = this.conn.createStatement();
            this.currentStmt = new Vector();
            this.batchHistory = new Hashtable();
            this.plansHistory = new Hashtable();
            this.currentStmtModel = new StatementsModel();
            this.pdf.currentStatementTable.setModel(this.currentStmtModel);
            this.capturedStmtModel = new StatementsModel();
            this.pdf.capturedStatementsTable.setModel(this.capturedStmtModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshStmt() {
        try {
            Batch batch;
            int i;
            this.rs = this.stmt.executeQuery("select P.spid, P.enginenum, P.status, P.suid, suser_name(P.suid), P.hostname, P.hostprocess, P.cmd, P.cpu, P.physical_io, P.memusage, LocksHeld, P.blocked, P.dbid, db_name(P.dbid), P.uid, '' /*user_name(P.uid)*/, P.gid, P.tran_name, P.time_blocked, P.network_pktsz, P.fid, P.execlass, P.priority, P.affinity, P.id, object_name(P.id,P.dbid), P.stmtnum, P.linenum, P.origsuid, P.block_xloid, P.clientname, P.clienthostname,  P.clientapplname, P.sys_id, P.ses_id, P.loggedindatetime, P.ipaddr,  program_name=convert(varchar,P.program_name), CPUTime, WaitTime, LogicalReads, PhysicalReads, PagesRead, PhysicalWrites, PagesWritten, MemUsageKB, ScanPgs =  TableAccesses,IdxPgs = IndexAccesses, TmpTbl = TempDbObjects, UlcBytWrite =  ULCBytesWritten, UlcFlush = ULCFlushes, ULCFlushFull, Transactions, Commits, Rollbacks, PacketsSent, PacketsReceived, BytesSent, BytesReceived from sysprocesses P , monProcessActivity A, monProcessNetIO N where P.kpid=A.KPID and N.KPID=P.kpid and P.kpid=" + Integer.toString(this.kpid));
            this.rs.next();
            if (this.rs.getRow() > 0) {
                this.spid = (Integer)this.rs.getObject(1);
                this.pdf.spidFld.setText(this.rs.getObject(1).toString());
                this.pdf.enginenumFld.setText(this.rs.getObject(2).toString());
                this.pdf.statusFld.setText(this.rs.getObject(3).toString());
                this.pdf.suidFld.setText(this.rs.getObject(4).toString());
                this.pdf.suser_nameFld.setText(this.rs.getObject(5) == null ? "" : this.rs.getObject(5).toString());
                this.pdf.hostnameFld.setText(this.rs.getObject(6).toString());
                this.pdf.hostprocessFld.setText(this.rs.getObject(7).toString());
                this.pdf.cmdFld.setText(this.rs.getObject(8).toString());
                this.pdf.cpuFld.setText(this.rs.getObject(9).toString());
                this.pdf.physical_ioFld.setText(this.rs.getObject(10).toString());
                this.pdf.memusageFld.setText(this.rs.getObject(11).toString());
                this.pdf.LocksHeldFld.setText(this.rs.getObject(12).toString());
                this.pdf.blockedFld.setText(this.rs.getObject(13).toString());
                this.pdf.dbidFld.setText(this.rs.getObject(14).toString());
                this.pdf.db_nameFld.setText(this.rs.getObject(15).toString());
                this.pdf.uidFld.setText(this.rs.getObject(16).toString());
                this.pdf.user_nameFld.setText(this.rs.getObject(17).toString());
                this.pdf.gidFld.setText(this.rs.getObject(18).toString());
                this.pdf.tran_nameFld.setText(this.rs.getObject(19) == null ? "" : this.rs.getObject(19).toString());
                this.pdf.time_blockedFld.setText(this.rs.getObject(20) == null ? "" : this.rs.getObject(20).toString());
                this.pdf.network_pktszFld.setText(this.rs.getObject(21) == null ? "" : this.rs.getObject(21).toString());
                this.pdf.fidFld.setText(this.rs.getObject(22) == null ? "" : this.rs.getObject(22).toString());
                this.pdf.execlassFld.setText(this.rs.getObject(23) == null ? "" : this.rs.getObject(23).toString());
                this.pdf.priorityFld.setText(this.rs.getObject(24) == null ? "" : this.rs.getObject(24).toString());
                this.pdf.affinityFld.setText(this.rs.getObject(25) == null ? "" : this.rs.getObject(25).toString());
                this.pdf.procIDFld.setText(this.rs.getObject(26) == null ? "" : this.rs.getObject(26).toString());
                this.pdf.object_nameFld.setText(this.rs.getObject(27) == null ? "" : this.rs.getObject(27).toString());
                this.pdf.stmtnumFld.setText(this.rs.getObject(28) == null ? "" : this.rs.getObject(28).toString());
                this.pdf.linenumFld.setText(this.rs.getObject(29) == null ? "" : this.rs.getObject(29).toString());
                this.pdf.origsuidFld.setText(this.rs.getObject(30) == null ? "" : this.rs.getObject(30).toString());
                this.pdf.block_xloidFld.setText(this.rs.getObject(31) == null ? "" : this.rs.getObject(31).toString());
                this.pdf.clientnameFld.setText(this.rs.getObject(32) == null ? "" : this.rs.getObject(32).toString());
                this.pdf.clienthostnameFld.setText(this.rs.getObject(33) == null ? "" : this.rs.getObject(33).toString());
                this.pdf.clientapplnameFld.setText(this.rs.getObject(34) == null ? "" : this.rs.getObject(34).toString());
                this.pdf.sys_idFld.setText(this.rs.getObject(35) == null ? "" : this.rs.getObject(35).toString());
                this.pdf.ses_idFld.setText(this.rs.getObject(36) == null ? "" : this.rs.getObject(36).toString());
                this.pdf.loggedindatetimeFld.setText(this.rs.getObject(37) == null ? "" : this.rs.getObject(37).toString());
                this.pdf.ipaddrFld.setText(this.rs.getObject(38) == null ? "" : this.rs.getObject(38).toString());
                this.pdf.program_nameFld.setText(this.rs.getObject(39).toString());
                this.pdf.CPUTimeFld.setText(this.rs.getObject(40).toString());
                this.pdf.WaitTimeFld.setText(this.rs.getObject(41).toString());
                this.pdf.LogicalReadsFld.setText(this.rs.getObject(42).toString());
                this.pdf.PhysicalReadsFld.setText(this.rs.getObject(43).toString());
                this.pdf.PagesReadFld.setText(this.rs.getObject(44).toString());
                this.pdf.PhysicalWritesFld.setText(this.rs.getObject(45).toString());
                this.pdf.PagesWrittenFld.setText(this.rs.getObject(46).toString());
                this.pdf.MemUsageKBFld.setText(this.rs.getObject(47).toString());
                this.pdf.ScanPgsFld.setText(this.rs.getObject(48).toString());
                this.pdf.IdxPgsFld.setText(this.rs.getObject(49).toString());
                this.pdf.TmpTblFld.setText(this.rs.getObject(50).toString());
                this.pdf.UlcBytWriteFld.setText(this.rs.getObject(51).toString());
                this.pdf.UlcFlushFld.setText(this.rs.getObject(52).toString());
                this.pdf.ULCFlushFullFld.setText(this.rs.getObject(53).toString());
                this.pdf.TransactionsFld.setText(this.rs.getObject(54).toString());
                this.pdf.CommitsFld.setText(this.rs.getObject(55).toString());
                this.pdf.RollbacksFld.setText(this.rs.getObject(56).toString());
                this.pdf.PacketsSentFld.setText(this.rs.getObject(57).toString());
                this.pdf.PacketsReceivedFld.setText(this.rs.getObject(58).toString());
                this.pdf.BytesSentFld.setText(this.rs.getObject(59).toString());
                this.pdf.BytesReceivedFld.setText(this.rs.getObject(60).toString());
            } else {
                this.pdf.statusBarLbl.setText("Process disconnected");
                this.stopRefresh();
            }
            if (this.stmtStat) {
                this.rs = this.stmt.executeQuery("select  BatchID, LineNumber, dbname=db_name(DBID), procname=isnull(object_name(ProcedureID,DBID),''), CpuTime, WaitTime, MemUsageKB, PhysicalReads, LogicalReads, PagesModified, PacketsSent, PacketsReceived, NetworkPacketSize, PlansAltered, StartTime, PlanID, DBID,ProcedureID from monProcessStatement where KPID=" + Integer.toString(this.kpid));
                ResultSetMetaData rsmdCurStmt = this.rs.getMetaData();
                int nbColsCurStmt = rsmdCurStmt.getColumnCount();
                if (this.currentStmtColNames == null) {
                    this.currentStmtColNames = new Vector();
                    i = 1;
                    while (i <= nbColsCurStmt) {
                        this.currentStmtColNames.add(rsmdCurStmt.getColumnName(i));
                        ++i;
                    }
                }
                this.currentStmtRow = null;
                this.currentBatchID = -1;
                this.currentDBID = -1;
                this.currentProcedureID = -1;
                while (this.rs.next()) {
                    this.currentStmtRow = new Vector();
                    i = 1;
                    while (i <= nbColsCurStmt) {
                        this.currentStmtRow.add(this.rs.getObject(i));
                        ++i;
                    }
                    this.currentBatchID = this.rs.getInt(1);
                    this.currentDBID = this.rs.getInt(17);
                    this.currentProcedureID = this.rs.getInt(18);
                }
            }
            if (this.currentBatchID == -1) {
                this.currentBatch = null;
            }
            if (this.currentBatchID == -1 && this.selectedStatement == -1) {
                this.pdf.batchTextArea.setText("");
            }
            if (this.currentBatchID != this.previousBatchID && this.currentBatchID != -1 && this.SQLTextMonitor && this.batchCapture) {
                this.rs = this.stmt.executeQuery("select LineNumber,SQLText from monProcessSQLText where KPID=" + Integer.toString(this.kpid) + " and BatchID=" + Integer.toString(this.currentBatchID) + " order by LineNumber,SequenceInLine");
                this.currentBatch = new Batch(this.currentBatchID);
                int curLine = 0;
                StringBuffer lineSb = null;
                while (this.rs.next()) {
                    int lineNum = this.rs.getInt(1);
                    if (lineNum != curLine) {
                        if (lineSb != null) {
                            this.currentBatch.addLine(lineSb);
                        }
                        curLine = lineNum;
                        lineSb = new StringBuffer();
                    }
                    lineSb.append(this.rs.getString(2));
                }
                if (lineSb != null) {
                    this.currentBatch.addLine(lineSb);
                }
                this.batchHistory.put(new Integer(this.currentBatchID), this.currentBatch);
                if (this.selectedStatement == -1) {
                    this.displayCurrentBatch();
                }
            }
            if (this.stmtPipe && this.stmtPipeMsg) {
                this.rs = this.stmt.executeQuery("select  BatchID, LineNumber, dbname=db_name(DBID), procname=isnull(object_name(ProcedureID,DBID),''), Elapsed_ms=datediff(ms,StartTime, EndTime),CpuTime, WaitTime, MemUsageKB, PhysicalReads, LogicalReads, PagesModified, PacketsSent, PacketsReceived, NetworkPacketSize, PlansAltered, StartTime, EndTime, PlanID, DBID,ProcedureID from monSysStatement where KPID=" + Integer.toString(this.kpid));
                ResultSetMetaData rsmd = this.rs.getMetaData();
                int nbCols = rsmd.getColumnCount();
                if (this.capturedStmtColNames == null) {
                    this.capturedStmtColNames = new Vector();
                    i = 1;
                    while (i <= nbCols) {
                        this.capturedStmtColNames.add(rsmd.getColumnName(i));
                        ++i;
                    }
                }
                this.newStatements = new Vector();
                while (this.rs.next()) {
                    Vector<Object> row = new Vector<Object>();
                    int i2 = 1;
                    while (i2 <= nbCols) {
                        row.add(this.rs.getObject(i2));
                        ++i2;
                    }
                    this.newStatements.add(row);
                }
            }
            if (this.sqlTextPipe && this.sqlTextPipeMsg) {
                this.rs = this.stmt.executeQuery("select BatchID, SQLText from monSysSQLText where KPID=" + Integer.toString(this.kpid) + " order by BatchID, SequenceInBatch");
                int curBatchId = -1;
                Batch batch2 = null;
                StringBuffer sqlSb = null;
                while (this.rs.next()) {
                    int batchId = this.rs.getInt(1);
                    if (batchId != curBatchId) {
                        if (curBatchId != -1) {
                            batch2.addLine(sqlSb);
                            this.batchHistory.put(new Integer(curBatchId), batch2);
                        }
                        curBatchId = batchId;
                        batch2 = new Batch(curBatchId);
                        sqlSb = new StringBuffer();
                    }
                    sqlSb.append(this.rs.getString(2));
                }
                if (curBatchId != -1) {
                    batch2.addLine(sqlSb);
                    Batch alreadyCapturedBatch = (Batch)this.batchHistory.get(new Integer(curBatchId));
                    if (alreadyCapturedBatch == null) {
                        this.batchHistory.put(new Integer(curBatchId), batch2);
                    }
                }
            }
            if (this.planTextPipe && this.planTextPipeMsg) {
                this.rs = this.stmt.executeQuery("select BatchID, PlanID, PlanText, DBID, ProcedureID from monSysPlanText where KPID=" + Integer.toString(this.kpid) + " order by PlanID, SequenceNumber");
                int curBatchId = -1;
                int curPlanId = -1;
                int curProcId = -1;
                int curDbId = -1;
                Batch batch3 = null;
                StringBuffer planSb = null;
                while (this.rs.next()) {
                    int batchID = this.rs.getInt(1);
                    int planID = this.rs.getInt(2);
                    int dbId = this.rs.getInt(4);
                    int procId = this.rs.getInt(5);
                    if (planID != curPlanId || batchID != curBatchId || dbId != curDbId || procId != curProcId) {
                        if (curPlanId != -1) {
                            batch3.addLine(planSb);
                            this.plansHistory.put(String.valueOf(Integer.toString(curBatchId)) + "-" + Integer.toString(curDbId) + "-" + Integer.toString(curProcId), batch3);
                        }
                        curBatchId = batchID;
                        curPlanId = planID;
                        curDbId = dbId;
                        curProcId = procId;
                        batch3 = new Batch(curPlanId);
                        planSb = new StringBuffer();
                    }
                    planSb.append(this.rs.getString(3));
                }
                if (curPlanId != -1) {
                    batch3.addLine(planSb);
                    this.plansHistory.put(String.valueOf(Integer.toString(curBatchId)) + "-" + Integer.toString(curDbId) + "-" + Integer.toString(curProcId), batch3);
                }
            }
            if (this.has_sa_role && this.currentBatchID != -1 && (batch = (Batch)this.plansHistory.get(String.valueOf(Integer.toString(this.currentBatchID)) + "-" + Integer.toString(this.currentDBID) + "-" + this.currentProcedureID)) == null) {
                this.stmt.executeUpdate("sp_showplanfull " + Integer.toString(this.spid));
                StringBuffer planSb = null;
                SQLWarning sqlw = this.stmt.getWarnings();
                do {
                    if (planSb == null) {
                        planSb = new StringBuffer();
                    }
                    if (sqlw.getErrorCode() == 10233 || sqlw.getSQLState() == "010P4") break;
                    planSb = planSb.append(sqlw.getMessage());
                } while ((sqlw = sqlw.getNextWarning()) != null);
                if (planSb != null) {
                    batch = new Batch(this.currentBatchID);
                    batch.addLine(planSb);
                    this.plansHistory.put(String.valueOf(Integer.toString(this.currentBatchID)) + "-" + Integer.toString(this.currentDBID) + "-" + Integer.toString(this.currentProcedureID), batch);
                }
            }
            if (this.selectedStatement == -1) {
                this.displayPlan(this.currentBatchID, 0, this.currentDBID, this.currentProcedureID);
            }
            Runnable updatePanel_inSwingThread = new Runnable(){

                public void run() {
                    RefreshProcess.this.updatePanel_code();
                }
            };
            SwingUtilities.invokeLater(updatePanel_inSwingThread);
        }
        catch (SQLException SQLEx) {
            System.out.println("RefreshProcess : " + SQLEx);
            System.out.println("Error Code=" + SQLEx.getErrorCode());
            SQLEx.printStackTrace();
        }
    }

    public void displayCurrentBatch() {
        if (this.currentBatch == null) {
            this.pdf.batchTextArea.setText("");
            return;
        }
        Iterator bi = this.currentBatch.getIterator();
        StringBuffer lineSb = new StringBuffer();
        int lineNum = 0;
        while (bi.hasNext()) {
            ++lineNum;
            lineSb.append(bi.next() + "\n");
        }
        this.pdf.batchTextArea.setText(lineSb.toString());
    }

    public void displayBatch(int batchId) {
        Batch batch = (Batch)this.batchHistory.get(new Integer(batchId));
        if (batch == null) {
            this.pdf.batchTextArea.setText("");
            return;
        }
        if (batch.getBatchId() != batchId) {
            System.out.println("Asemon.RefreshProcess : bd batchId, asked " + batchId + " returned " + batch.getBatchId());
        }
        Iterator bi = batch.getIterator();
        StringBuffer lineSb = new StringBuffer();
        int lineNum = 0;
        while (bi.hasNext()) {
            ++lineNum;
            lineSb.append(bi.next() + "\n");
        }
        this.pdf.batchTextArea.setText(lineSb.toString());
    }

    public void displayPlan(int batchId, int planId, int dbId, int procId) {
        Batch batch = (Batch)this.plansHistory.get(String.valueOf(Integer.toString(batchId)) + "-" + Integer.toString(dbId) + "-" + Integer.toString(procId));
        if (batch == null) {
            this.pdf.planTextArea.setText("");
            return;
        }
        Iterator bi = batch.getIterator();
        StringBuffer lineSb = new StringBuffer();
        int lineNum = 0;
        while (bi.hasNext()) {
            ++lineNum;
            lineSb.append(bi.next() + "\n");
        }
        this.pdf.planTextArea.setText(lineSb.toString());
    }

    public void setSelectedStatement(int rowid) {
        if (rowid != this.selectedStatement) {
            this.selectedStatement = rowid;
            if (rowid >= 0) {
                int batchId = (Integer)this.capturedStmtModel.getValueAt(rowid, 0);
                int planId = (Integer)this.capturedStmtModel.getValueAt(rowid, 17);
                int dbId = (Integer)this.capturedStmtModel.getValueAt(rowid, 18);
                int procId = (Integer)this.capturedStmtModel.getValueAt(rowid, 19);
                this.displayBatch(batchId);
                this.displayPlan(batchId, planId, dbId, procId);
            } else {
                this.displayCurrentBatch();
                this.displayPlan(this.currentBatchID, 0, this.currentDBID, this.currentProcedureID);
            }
        }
    }

    public int getSelectedStatement() {
        return this.selectedStatement;
    }

    private void updatePanel_code() {
        int i;
        if (!this.currentSMInitialized) {
            this.currentStmtModel.setDataVector(this.currentStmt, this.currentStmtColNames);
            this.currentSMInitialized = true;
        }
        if (this.currentStmtRow != null) {
            if (this.currentStmtModel.getRowCount() == 0) {
                this.currentStmtModel.addRow(this.currentStmtRow);
                this.currentStmtModel.setRowCount(1);
            } else {
                i = 0;
                while (i < this.currentStmtRow.size()) {
                    this.currentStmtModel.setValueAt(this.currentStmtRow.get(i), 0, i);
                    ++i;
                }
            }
        } else if (this.currentStmtModel.getRowCount() == 1) {
            this.currentStmtModel.removeRow(0);
            this.currentStmtModel.setRowCount(0);
        }
        if (this.newStatements != null) {
            if (!this.capturedSMInitialized) {
                this.capturedStmtModel.setDataVector(new Vector(), this.capturedStmtColNames);
                this.capturedSMInitialized = true;
            }
            i = 0;
            while (i < this.newStatements.size()) {
                this.capturedStmtModel.addRow((Vector)this.newStatements.get(i));
                ++this.stmtHistoryCnt;
                this.capturedStmtModel.setRowCount(this.stmtHistoryCnt);
                ++i;
            }
        }
    }

    public void run() {
        try {
            this.rs = this.stmt.executeQuery("sp_configure 'SQL batch capture'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) != 1) continue;
                this.batchCapture = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'max SQL text monitored'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) <= 0) continue;
                this.SQLTextMonitor = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'plan text pipe active'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) != 1) continue;
                this.planTextPipe = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'plan text pipe max messages'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) <= 0) continue;
                this.planTextPipeMsg = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'sql text pipe active'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) != 1) continue;
                this.sqlTextPipe = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'sql text pipe max messages'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) <= 0) continue;
                this.sqlTextPipeMsg = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'statement pipe active'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) != 1) continue;
                this.stmtPipe = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'statement pipe max messages'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) <= 0) continue;
                this.stmtPipeMsg = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'statement statistics active'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) != 1) continue;
                this.stmtStat = true;
            }
            this.rs = this.stmt.executeQuery("sp_configure 'process wait events'");
            while (this.rs.next()) {
                if (this.rs.getInt(5) != 1) continue;
                this.procWaitEvents = true;
            }
            ResultSet rs = this.stmt.executeQuery("sp_activeroles");
            while (rs.next()) {
                if (!rs.getString(1).equals("sa_role")) continue;
                this.has_sa_role = true;
            }
        }
        catch (SQLException SQLEx) {
            System.out.println("asemon : error in refreshProcess geting options. " + SQLEx);
            SQLEx.printStackTrace();
        }
        StringBuffer msg = new StringBuffer();
        if (!this.stmtStat) {
            msg = msg.append("       'statement statistics active' to 1\n");
        }
        if (!this.batchCapture) {
            msg = msg.append("       'SQL batch capture' to 1 \n");
        }
        if (!this.SQLTextMonitor) {
            msg = msg.append("       'max SQL text monitored' to a value greater than 0 (ex : 4094)\n");
        }
        if (!this.stmtPipe) {
            msg = msg.append("       'statement pipe active' to 1\n");
        }
        if (!this.stmtPipeMsg) {
            msg = msg.append("       'statement pipe max messages' to a value greater than 0\n");
        }
        if (!this.planTextPipe) {
            msg = msg.append("       'plan text pipe active' to 1\n");
        }
        if (!this.planTextPipeMsg) {
            msg = msg.append("       'plan text pipe max messages' to a value greater than 0\n");
        }
        if (!this.sqlTextPipe) {
            msg = msg.append("       'sql text pipe active' to 1\n");
        }
        if (!this.sqlTextPipeMsg) {
            msg = msg.append("       'sql text pipe max messages' to a value greater than 0\n");
        }
        if (!this.procWaitEvents) {
            msg = msg.append("       'process wait events' to 1\n");
        }
        if (!this.has_sa_role) {
            if (msg.length() > 0) {
                msg = msg.append(" and ");
            }
            msg = msg.append("user should have 'sa_role'");
        }
        if (msg.length() > 0) {
            msg.insert(0, "RECOMMENDATION : for full features, configure the following parameters :\n\n");
            MessageDialog messageDialog = new MessageDialog((Frame)this.pdf, "Warning", msg.toString());
        }
        if (this.has_sa_role) {
            try {
                this.rs = this.stmt.executeQuery("select name from sybsystemprocs..sysobjects where name ='sp_showplanfull' and type='P'");
                this.rs.next();
                if (this.rs.getRow() == 0) {
                    this.stmt.executeUpdate("use sybsystemprocs");
                    this.stmt.executeUpdate("create proc sp_showplanfull @spid int as declare @batchid int,  @contextid int,  @stmtid int,  @return_value int,  @procname varchar(30), @procid int, @dbid int  set nocount on  select @return_value = show_plan(@spid, -1, -1, -1) if (@return_value < 0) begin        print 'No plan for spid %1!', @spid        goto fin end else begin        select @batchid = @return_value end  select @return_value = show_plan(@spid, @batchid, -1, -1) if (@return_value < 0) begin        print 'No plan for spid %1!', @spid        goto fin end else begin        select @contextid = @return_value end  select @procname=object_name(id, dbid), @procid=id, @dbid=dbid from master..sysprocesses where spid=@spid if @procid>0   print 'Plan for procedure : %1! (id=%2!, dbid=%3!)', @procname, @procid, @dbid  select @stmtid =1 while (1=1) begin                select @return_value = show_plan(@spid, @batchid, @contextid , @stmtid)                if (@return_value < 0)                       break                else                select @stmtid =@stmtid +1 end fin:");
                    this.stmt.executeUpdate("use master");
                }
            }
            catch (SQLException sqlex) {
                sqlex.printStackTrace();
            }
        }
        String[] colsCalcDiff_CMProcObjects = new String[]{"LogicalReads", "PhysicalReads", "PhysicalAPFReads"};
        String[] colsCalcPCT_CMProcObjects = new String[]{};
        this.CMProcObjects = new CountersModel("CMProcObjects", "select DBName, ObjectID, OwnerUserID, ObjectName, IndexID, ObjectType, LogicalReads, PhysicalReads, PhysicalAPFReads from monProcessObject where KPID=" + Integer.toString(this.kpid), this.pdf.processObjectsPanel, 1, 2, 0, colsCalcDiff_CMProcObjects, colsCalcPCT_CMProcObjects);
        String[] colsCalcDiff_CMProcWaits = new String[]{"WaitTime", "Waits"};
        String[] colsCalcPCT_CMProcWaits = new String[]{};
        this.CMProcWaits = new CountersModel("CMProcWaits", "select Class=C.Description,Event=I.Description,W.WaitEventID,WaitTime,Waits from monProcessWaits W, monWaitEventInfo I, monWaitClassInfo C where W.WaitEventID=I.WaitEventID and I.WaitClassID=C.WaitClassID and KPID=" + Integer.toString(this.kpid), this.pdf.processWaitsPanel, 1, 2, 3, colsCalcDiff_CMProcWaits, colsCalcPCT_CMProcWaits);
        boolean firstTime = true;
        while (this.refreshProcessFlag) {
            try {
                if (!firstTime) {
                    Thread.sleep(this.pdf.processRefreshInterv * 1000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            firstTime = false;
            this.refreshProcess();
        }
        try {
            this.conn.close();
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
        }
        this.pdf.statusBarLbl.setText("Process disconnected");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void refreshProcess() {
        try {
            try {
                this.pdf.statusBarLbl.setText("Refreshing");
                this.refreshStmt();
                this.CMProcObjects.refreshCM();
                if (this.procWaitEvents) {
                    this.CMProcWaits.refreshCM();
                }
            }
            catch (Exception e) {
                System.out.println("asemon : error in refreshProcess loop. " + e);
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.pdf.statusBarLbl.setText("");
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.pdf.statusBarLbl.setText("");
            return;
        }
    }

    public void stopRefresh() {
        this.refreshProcessFlag = false;
    }

    class StatementsModel
    extends DefaultTableModel {
        public StatementsModel() {
        }

        public StatementsModel(int row, int col) {
            super(row, col);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

