/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.GetCounters;
import asemon.MainFrame;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;

public class SamplingCnt {
    public Vector colNames;
    public Vector rows;
    public Hashtable keys;
    public Timestamp samplingTime;
    public long interval;
    public int nbRows;
    public int nbCols;

    public void SamplingCnt() {
        this.colNames = null;
        this.rows = null;
        this.keys = null;
        this.interval = 0L;
        this.nbRows = 0;
        this.nbCols = 0;
    }

    public Vector getColNames() {
        return this.colNames;
    }

    private void checkWarnings(Statement st) throws Exception {
        boolean hasWarning = false;
        try {
            SQLWarning w = st.getWarnings();
            while (w != null) {
                hasWarning = true;
                System.out.println("SamplingCnt. Warning : " + w);
                w = w.getNextWarning();
            }
        }
        catch (Exception ex) {
            System.out.println("SamplingCnt.getWarnings : " + ex);
            ex.printStackTrace();
        }
        if (hasWarning) {
            throw new Exception("SQL Warning");
        }
    }

    public boolean getCnt(Connection cnx, String sql, int idKey1, int idKey2, int idKey3) {
        try {
            Statement stmt = cnx.createStatement();
            ResultSet rs = stmt.executeQuery("select getdate() " + sql);
            this.checkWarnings(stmt);
            rs.next();
            this.samplingTime = rs.getTimestamp(1);
            rs.next();
            stmt.getMoreResults();
            this.checkWarnings(stmt);
            rs = stmt.getResultSet();
            ResultSetMetaData rsmd = rs.getMetaData();
            if (this.colNames == null) {
                this.colNames = new Vector();
                this.nbCols = rsmd.getColumnCount();
                int i = 1;
                while (i <= this.nbCols) {
                    this.colNames.add(rsmd.getColumnName(i));
                    ++i;
                }
            }
            this.nbRows = 0;
            this.rows = new Vector();
            if (idKey1 > 0) {
                this.keys = new Hashtable();
            }
            System.out.println("---");
            while (rs.next()) {
                String key = "";
                Vector<Object> row = new Vector<Object>();
                this.rows.add(row);
                int i = 1;
                while (i <= this.nbCols) {
                    Object val = rs.getObject(i);
                    if (this.rows.size() == 1) {
                        System.out.println("READ_RESULTSET(row 0): col=" + i + ", colName=" + (this.colNames.get(i - 1) + "                                   ").substring(0, 25) + ", ObjectType=" + (val == null ? "NULL-VALUE" : val.getClass().getName()));
                    }
                    row.add(val);
                    if (val != null && (i == idKey1 || i == idKey2 || i == idKey3)) {
                        key = key.concat(val.toString());
                    }
                    ++i;
                }
                if (idKey1 > 0) {
                    this.keys.put(key, new Integer(this.nbRows));
                }
                ++this.nbRows;
            }
            return true;
        }
        catch (SQLException sqlEx) {
            System.out.println("SamplingCnt.getCnt : " + sqlEx.getErrorCode() + " " + sqlEx.getMessage());
            if (sqlEx.getMessage().equals("JZ0C0: Connection is already closed.")) {
                GetCounters.setRefreshing(false);
                MainFrame.terminateConnection();
            }
            return false;
        }
        catch (Exception ev) {
            System.out.println("SamplingCnt.getCnt : " + ev);
            ev.printStackTrace();
            return false;
        }
    }

    public Object getValue(int row, int col) {
        try {
            if (row < 0 || row >= this.nbRows) {
                System.out.println("Bad row number : " + row);
                System.exit(1);
            }
            if (col <= 0 || col > this.nbCols) {
                System.out.println("Bad col number : " + col);
                System.exit(1);
            }
            Vector aRow = (Vector)this.rows.get(row);
            return aRow.elementAt(col - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void checkType(SamplingCnt oldcnt, int oldrowid, int oldcol, SamplingCnt newcnt, int newrowid, int newcol) {
        Vector oldrow = (Vector)oldcnt.rows.get(oldrowid);
        Object oldval = oldrow.get(oldcol);
        Vector newrow = (Vector)newcnt.rows.get(newrowid);
        Object newval = newrow.get(newcol);
        if (oldval.getClass().toString().equals("class java.lang.Integer") && newval.getClass().toString().equals("class java.lang.Integer")) {
            return;
        }
        System.out.println("BAD SamplingCnt :");
        System.out.println("  OLD : class = " + oldval.getClass().toString());
        System.out.println("  OLD :Cols :" + oldcnt.colNames);
        System.out.println("  OLD :Nbrows=" + oldcnt.nbRows + " size=" + oldcnt.rows.size() + " curentRow=" + oldrowid + " currentCol=" + oldcol);
        System.out.println("  NEW : class = " + newval.getClass().toString());
        System.out.println("  NEW :Cols :" + newcnt.colNames);
        System.out.println("  NEW :Nbrows=" + newcnt.nbRows + " size=" + newcnt.rows.size() + " curentRow=" + newrowid + " currentCol=" + newcol);
    }

    public static SamplingCnt computeDiffCnt(SamplingCnt oldSample, SamplingCnt newSample, int idKey1, int idKey2, int idKey3, Vector bitmapColsCalcDiff) {
        String key = new String("");
        Object val = null;
        SamplingCnt diffCnt = new SamplingCnt();
        diffCnt.nbCols = newSample.nbCols;
        diffCnt.nbRows = newSample.nbRows;
        diffCnt.rows = new Vector();
        diffCnt.keys = new Hashtable();
        diffCnt.colNames = newSample.colNames;
        diffCnt.samplingTime = newSample.samplingTime;
        long newTsMilli = newSample.samplingTime.getTime();
        long oldTsMilli = oldSample.samplingTime.getTime();
        int newTsNano = newSample.samplingTime.getNanos();
        int oldTsNano = oldSample.samplingTime.getNanos();
        diffCnt.interval = newTsMilli - newTsMilli / 1000L * 1000L == (long)(newTsNano / 1000000) ? newTsMilli - oldTsMilli : newTsMilli - oldTsMilli + (long)((newTsNano - oldTsNano) / 1000000);
        if (idKey1 == 0) {
            Vector oldRow = (Vector)oldSample.rows.get(0);
            Vector newRow = (Vector)newSample.rows.get(0);
            Vector<Integer> diffRow = new Vector<Integer>();
            int i = 0;
            while (i < newSample.nbCols) {
                diffRow.add(new Integer((Integer)newRow.get(i) - (Integer)oldRow.get(i)));
                ++i;
            }
            diffCnt.rows.add(diffRow);
            return diffCnt;
        }
        int newRowId = 0;
        while (newRowId < newSample.nbRows) {
            int i;
            Vector newRow = (Vector)newSample.rows.get(newRowId);
            Vector diffRow = new Vector();
            key = newRow.get(idKey1 - 1).toString();
            if (idKey2 != 0) {
                key = key.concat(newRow.get(idKey2 - 1).toString());
            }
            if (idKey3 != 0) {
                key = key.concat(newRow.get(idKey3 - 1).toString());
            }
            diffCnt.keys.put(key, new Integer(newRowId));
            Integer r = (Integer)oldSample.keys.get(key);
            int oldRowId = r != null ? r : -1;
            if (oldRowId != -1) {
                Vector oldRow = (Vector)oldSample.rows.get(oldRowId);
                i = 0;
                while (i < newSample.nbCols) {
                    if ((Integer)bitmapColsCalcDiff.get(i) == 0) {
                        diffRow.add(newRow.get(i));
                    } else if (newRow.get(i).getClass().toString().equals("class java.math.BigDecimal")) {
                        long prevSample = ((BigDecimal)oldRow.get(i)).longValue();
                        long thisSample = ((BigDecimal)newRow.get(i)).longValue();
                        long diff = thisSample - prevSample;
                        diffRow.add(new Long(diff));
                    } else {
                        int prevSample = (Integer)oldRow.get(i);
                        int thisSample = (Integer)newRow.get(i);
                        int diff = thisSample - prevSample;
                        if (diff < 0) {
                            diff = 0;
                        }
                        diffRow.add(new Integer(diff));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < newSample.nbCols) {
                    diffRow.add(newRow.get(i));
                    ++i;
                }
            }
            diffCnt.rows.add(diffRow);
            ++newRowId;
        }
        return diffCnt;
    }
}

