/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.TrendGraph;
import asemon.VerticalFlowLayout;
import asemon.XYConstraints;
import asemon.XYLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SummaryPanel
extends JPanel {
    static Logger logger;
    private JPanel summDataPanel = new JPanel();
    private JPanel summGraphPanel = new JPanel();
    private XYLayout summData_xYLayout = new XYLayout();
    private JLabel lb_serverName = new JLabel();
    private JLabel lb_aseVersion = new JLabel();
    private JLabel lb_StartDate = new JLabel();
    private JLabel lb_DaysRunning = new JLabel();
    private JLabel lb_CountersCleared = new JLabel();
    private JLabel lb_CheckPoints = new JLabel();
    private JLabel lb_NumDeadlocks = new JLabel();
    private JLabel lb_DiagnosticDumps = new JLabel();
    private JLabel lb_Connections = new JLabel();
    private JLabel lb_MaxRecovery = new JLabel();
    private JLabel lb_LockWaitThreshold = new JLabel();
    private JLabel lb_LockWaits = new JLabel();
    public JTextField serverName = new JTextField();
    private JTextField aseVersion = new JTextField();
    private JTextField StartDate = new JTextField();
    private JTextField DaysRunning = new JTextField();
    public JTextField CountersCleared = new JTextField();
    private JTextField CheckPoints = new JTextField();
    private JTextField NumDeadlocks = new JTextField();
    private JTextField DiagnosticDumps = new JTextField();
    private JTextField Connections = new JTextField();
    private JTextField LockWaitThreshold = new JTextField();
    private JTextField LockWaits = new JTextField();
    private JTextField MaxRecovery = new JTextField();
    private JLabel lb_title = new JLabel();
    private VerticalFlowLayout sumGraphVerticalFlowLayout = new VerticalFlowLayout();
    private BorderLayout summPanelBorderLayout = new BorderLayout();
    private BorderLayout summGraphBorderLayout = new BorderLayout();
    private JScrollPane summGraphScrollPane = new JScrollPane();
    private JPanel summGraphPanVertical = new JPanel();
    private JLabel summGraphTitle = new JLabel();
    private JPanel panCPU = new JPanel();
    private BorderLayout borderLayouttrendCPU = new BorderLayout();
    private static String[] cpuLables;
    public static TrendGraph trendCPU;
    private JPanel panEngCPU = new JPanel();
    private BorderLayout borderLayouttrendEngCPU = new BorderLayout();
    private static String[] engCpuLables;
    public static TrendGraph trendEngCPU;
    private JPanel panOrdinaryIO = new JPanel();
    private BorderLayout borderLayouttrendIOData = new BorderLayout();
    private static String[] ordinaryIoLables;
    public static TrendGraph trendOrdinaryIO;
    private JPanel panTempdbIO = new JPanel();
    private BorderLayout borderLayouttrendTempdbData = new BorderLayout();
    private static String[] temdbIoLables;
    public static TrendGraph trendTempdbIO;
    private JPanel panDeviceIo = new JPanel();
    private BorderLayout borderLayouttrendDeviceIo = new BorderLayout();
    private static String[] serviceTimeLables;
    public static TrendGraph trendDeviceIo;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("asemon.CountersModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        cpuLables = new String[]{"System+User CPU", "System CPU", "User CPU"};
        trendCPU = new TrendGraph("CPU Summary of all Engines", cpuLables, true);
        engCpuLables = new String[]{"eng-0"};
        trendEngCPU = new TrendGraph("CPU Usage per Engine (System + User)", engCpuLables, true);
        ordinaryIoLables = new String[]{"Log", "Data"};
        trendOrdinaryIO = new TrendGraph("Number of IO Operations in User databases", ordinaryIoLables, false);
        temdbIoLables = new String[]{"Log", "Data"};
        trendTempdbIO = new TrendGraph("Number of IO Operations in tempdb", temdbIoLables, false);
        serviceTimeLables = new String[]{"Max", "Average"};
        trendDeviceIo = new TrendGraph("Device IO Service Time in Milliseconds", serviceTimeLables, false);
    }

    public SummaryPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.summDataPanel.setPreferredSize(new Dimension(320, 400));
        this.summGraphPanel.setPreferredSize(new Dimension(430, 400));
        this.summGraphPanel.setLayout(this.summGraphBorderLayout);
        this.setLayout(this.summPanelBorderLayout);
        this.summGraphTitle.setHorizontalAlignment(0);
        this.summGraphPanVertical.setBackground(Color.lightGray);
        this.summGraphPanVertical.setPreferredSize(new Dimension(400, 1000));
        this.summGraphScrollPane.setBorder(null);
        this.sumGraphVerticalFlowLayout.setHgap(10);
        this.sumGraphVerticalFlowLayout.setVgap(10);
        this.add((Component)this.summDataPanel, "Center");
        this.add((Component)this.summGraphPanel, "East");
        this.summGraphPanel.add((Component)this.summGraphScrollPane, "Center");
        this.summGraphScrollPane.getViewport().add((Component)this.summGraphPanVertical, null);
        this.lb_title.setFont(new Font("Dialog", 1, 16));
        this.lb_title.setText("Summary panel");
        this.lb_aseVersion.setHorizontalAlignment(4);
        this.lb_StartDate.setHorizontalAlignment(4);
        this.lb_DaysRunning.setHorizontalAlignment(4);
        this.lb_CountersCleared.setHorizontalAlignment(4);
        this.lb_CheckPoints.setHorizontalAlignment(4);
        this.lb_NumDeadlocks.setHorizontalAlignment(4);
        this.lb_DiagnosticDumps.setHorizontalAlignment(4);
        this.lb_Connections.setHorizontalAlignment(4);
        this.lb_LockWaitThreshold.setHorizontalAlignment(4);
        this.lb_LockWaits.setHorizontalAlignment(4);
        this.lb_MaxRecovery.setHorizontalAlignment(4);
        this.lb_serverName.setText("Server :");
        this.lb_serverName.setHorizontalAlignment(4);
        this.summDataPanel.setBackground(new Color(230, 230, 230));
        this.summDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.summDataPanel.setMaximumSize(new Dimension(10000, 32768));
        this.summDataPanel.setLayout(this.summData_xYLayout);
        this.lb_aseVersion.setText("ASE Version :");
        this.lb_StartDate.setText("StartDate :");
        this.lb_DaysRunning.setText("DaysRunning :");
        this.lb_CountersCleared.setText("CountersClearDate :");
        this.lb_CheckPoints.setText("Running CheckPoints :");
        this.lb_NumDeadlocks.setText("NumDeadlocks :");
        this.lb_DiagnosticDumps.setText("Diagnostic Dumps :");
        this.lb_Connections.setText("Connections :");
        this.lb_MaxRecovery.setText("Max Recovery :");
        this.lb_LockWaitThreshold.setText("LockWaitThreshold :");
        this.lb_LockWaits.setText("LockWaits :");
        this.serverName.setBackground(new Color(245, 245, 245));
        this.NumDeadlocks.setBackground(new Color(245, 245, 245));
        this.NumDeadlocks.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.NumDeadlocks.setMinimumSize(new Dimension(40, 21));
        this.NumDeadlocks.setPreferredSize(new Dimension(40, 21));
        this.DiagnosticDumps.setBackground(new Color(245, 245, 245));
        this.DiagnosticDumps.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.DiagnosticDumps.setMinimumSize(new Dimension(40, 21));
        this.DiagnosticDumps.setPreferredSize(new Dimension(40, 21));
        this.Connections.setBackground(new Color(245, 245, 245));
        this.Connections.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.Connections.setMinimumSize(new Dimension(40, 21));
        this.Connections.setPreferredSize(new Dimension(40, 21));
        this.LockWaitThreshold.setBackground(new Color(245, 245, 245));
        this.LockWaitThreshold.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.LockWaitThreshold.setMinimumSize(new Dimension(40, 21));
        this.LockWaitThreshold.setPreferredSize(new Dimension(40, 21));
        this.LockWaits.setBackground(new Color(245, 245, 245));
        this.LockWaits.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.LockWaits.setMinimumSize(new Dimension(40, 21));
        this.DaysRunning.setBackground(new Color(245, 245, 245));
        this.CheckPoints.setBackground(new Color(245, 245, 245));
        this.CountersCleared.setBackground(new Color(245, 245, 245));
        this.aseVersion.setBackground(new Color(245, 245, 245));
        this.StartDate.setBackground(new Color(245, 245, 245));
        this.LockWaits.setPreferredSize(new Dimension(40, 21));
        this.MaxRecovery.setBackground(new Color(245, 245, 245));
        this.MaxRecovery.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.MaxRecovery.setMinimumSize(new Dimension(40, 21));
        this.MaxRecovery.setPreferredSize(new Dimension(40, 21));
        int m = 30;
        int y = 14;
        this.summDataPanel.add((Component)this.lb_serverName, new XYConstraints(68, y += m, 69, -1));
        this.summDataPanel.add((Component)this.lb_aseVersion, new XYConstraints(68, y += m, 69, -1));
        this.summDataPanel.add((Component)this.lb_StartDate, new XYConstraints(68, y += m, 69, -1));
        this.summDataPanel.add((Component)this.lb_DaysRunning, new XYConstraints(48, y += m, 89, -1));
        this.summDataPanel.add((Component)this.lb_CountersCleared, new XYConstraints(12, y += m, 125, -1));
        this.summDataPanel.add((Component)this.lb_CheckPoints, new XYConstraints(5, y += m, 132, -1));
        this.summDataPanel.add((Component)this.lb_NumDeadlocks, new XYConstraints(26, y += m, 111, -1));
        this.summDataPanel.add((Component)this.lb_DiagnosticDumps, new XYConstraints(19, y += m, 118, -1));
        this.summDataPanel.add((Component)this.lb_Connections, new XYConstraints(44, y += m, 93, -1));
        this.summDataPanel.add((Component)this.lb_LockWaitThreshold, new XYConstraints(14, y += m, 123, -1));
        this.summDataPanel.add((Component)this.lb_LockWaits, new XYConstraints(53, y += m, 84, -1));
        this.summDataPanel.add((Component)this.lb_MaxRecovery, new XYConstraints(46, y += m, 91, -1));
        y = 10;
        this.summDataPanel.add((Component)this.serverName, new XYConstraints(141, y += m, 154, -1));
        this.summDataPanel.add((Component)this.aseVersion, new XYConstraints(141, y += m, 154, -1));
        this.summDataPanel.add((Component)this.StartDate, new XYConstraints(141, y += m, 154, -1));
        this.summDataPanel.add((Component)this.DaysRunning, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.CountersCleared, new XYConstraints(141, y += m, 154, -1));
        this.summDataPanel.add((Component)this.CheckPoints, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.NumDeadlocks, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.DiagnosticDumps, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.Connections, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.LockWaitThreshold, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.LockWaits, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.MaxRecovery, new XYConstraints(141, y += m, 81, -1));
        this.summDataPanel.add((Component)this.lb_title, new XYConstraints(5, 1, 135, 38));
        this.summGraphPanel.setBackground(Color.white);
        this.summGraphPanVertical.setLayout(this.sumGraphVerticalFlowLayout);
        this.summGraphTitle.setText("Trends");
        this.summGraphPanVertical.add((Component)this.summGraphTitle, null);
        this.panCPU.setLayout(this.borderLayouttrendCPU);
        this.panCPU.setPreferredSize(new Dimension(406, 160));
        this.panCPU.setBorder(BorderFactory.createLoweredBevelBorder());
        this.summGraphPanVertical.add((Component)this.panCPU, null);
        this.panCPU.add((Component)trendCPU.getChartPanel(), null);
        this.panEngCPU.setLayout(this.borderLayouttrendEngCPU);
        this.panEngCPU.setPreferredSize(new Dimension(406, 160));
        this.panEngCPU.setBorder(BorderFactory.createLoweredBevelBorder());
        this.summGraphPanVertical.add((Component)this.panEngCPU, null);
        this.panEngCPU.add((Component)trendEngCPU.getChartPanel(), null);
        this.panOrdinaryIO.setLayout(this.borderLayouttrendIOData);
        this.panOrdinaryIO.setPreferredSize(new Dimension(406, 160));
        this.panOrdinaryIO.setBorder(BorderFactory.createLoweredBevelBorder());
        this.summGraphPanVertical.add((Component)this.panOrdinaryIO, null);
        this.panOrdinaryIO.add((Component)trendOrdinaryIO.getChartPanel(), null);
        this.panTempdbIO.setLayout(this.borderLayouttrendTempdbData);
        this.panTempdbIO.setPreferredSize(new Dimension(406, 160));
        this.panTempdbIO.setBorder(BorderFactory.createLoweredBevelBorder());
        this.summGraphPanVertical.add((Component)this.panTempdbIO, null);
        this.panTempdbIO.add((Component)trendTempdbIO.getChartPanel(), null);
        this.panDeviceIo.setLayout(this.borderLayouttrendDeviceIo);
        this.panDeviceIo.setPreferredSize(new Dimension(406, 160));
        this.panDeviceIo.setBorder(BorderFactory.createLoweredBevelBorder());
        this.summGraphPanVertical.add((Component)this.panDeviceIo, null);
        this.panDeviceIo.add((Component)trendDeviceIo.getChartPanel(), null);
    }

    public synchronized void getSummaryData(Connection dbConnection) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering getSummaryData() method");
        }
        try {
            if (dbConnection == null) {
                return;
            }
            Statement stmt = dbConnection.createStatement();
            ResultSet rs = stmt.executeQuery("select aseVersion=@@version, * from monState");
            rs.next();
            String aseVersionStr = rs.getString("aseVersion");
            if (aseVersionStr.startsWith("Adaptive Server Enterprise/")) {
                int aseVersionNum = SummaryPanel.aseVersionStringToNumber(aseVersionStr);
                aseVersionStr = aseVersionStr.replaceFirst("Adaptive Server Enterprise/", "");
            }
            this.aseVersion.setText(aseVersionStr);
            this.StartDate.setText(rs.getString("StartDate"));
            this.DaysRunning.setText(rs.getString("DaysRunning"));
            this.CountersCleared.setText(rs.getString("CountersCleared"));
            this.CheckPoints.setText(rs.getString("CheckPoints"));
            this.NumDeadlocks.setText(rs.getString("NumDeadlocks"));
            this.DiagnosticDumps.setText(rs.getString("DiagnosticDumps"));
            this.Connections.setText(rs.getString("Connections"));
            this.MaxRecovery.setText(rs.getString("MaxRecovery"));
            this.LockWaitThreshold.setText(rs.getString("LockWaitThreshold"));
            this.LockWaits.setText(rs.getString("LockWaits"));
            rs.close();
        }
        catch (SQLException ev) {
            System.out.println("getSummaryData : " + ev);
        }
    }

    public static int aseVersionStringToNumber(String versionStr) {
        int aseVersionNumber = 0;
        String[] aseVersionParts = versionStr.split("/");
        if (aseVersionParts.length > 1) {
            String aseVersionNumberStr = aseVersionParts[1];
            String[] aseVersionNumberParts = aseVersionNumberStr.split("\\.");
            if (aseVersionNumberParts.length > 1) {
                try {
                    String versionPart = null;
                    if (aseVersionNumberParts.length >= 1) {
                        versionPart = aseVersionNumberParts[0].trim();
                        aseVersionNumber += 1000 * Integer.parseInt(versionPart);
                    }
                    if (aseVersionNumberParts.length >= 2) {
                        versionPart = aseVersionNumberParts[1].trim().substring(0, 1);
                        aseVersionNumber += 100 * Integer.parseInt(versionPart);
                    }
                    if (aseVersionNumberParts.length >= 3) {
                        versionPart = aseVersionNumberParts[2].trim().substring(0, 1);
                        aseVersionNumber += 10 * Integer.parseInt(versionPart);
                    }
                    if (aseVersionNumberParts.length >= 4) {
                        versionPart = aseVersionNumberParts[3].trim().substring(0, 1);
                        aseVersionNumber += 1 * Integer.parseInt(versionPart);
                    }
                }
                catch (RuntimeException e) {
                    System.out.println("Problems converting some part(s) of the version string '" + aseVersionNumberStr + "' into a number. The version number will be set to " + aseVersionNumber);
                }
            } else {
                System.out.println("There ASE version string seems to be faulty, cant find any '.' in the version number subsection '" + aseVersionNumberStr + "'.");
            }
        } else {
            System.out.println("There ASE version string seems to be faulty, cant find any / in the string '" + versionStr + "'.");
        }
        return aseVersionNumber;
    }

    public synchronized void clearSummaryData() {
        this.serverName.setText("");
        this.aseVersion.setText("");
        this.StartDate.setText("");
        this.DaysRunning.setText("");
        this.CountersCleared.setText("");
        this.CheckPoints.setText("");
        this.NumDeadlocks.setText("");
        this.DiagnosticDumps.setText("");
        this.Connections.setText("");
        this.MaxRecovery.setText("");
        this.LockWaitThreshold.setText("");
        this.LockWaits.setText("");
    }
}

