/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.CountersModel;
import asemon.CountersTableModel;
import asemon.MainFrame;
import asemon.ProcessDetailFrame;
import asemon.TableSorter;
import asemon.XYConstraints;
import asemon.XYLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TabularCntrPanel
extends JPanel {
    public CountersModel CM = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane scrollPanel = new JScrollPane();
    private JPanel headerPanel = new JPanel();
    private JLabel filteronLabel = new JLabel();
    private XYLayout headerxYLayout = new XYLayout();
    private JLabel filterValueLabel = new JLabel();
    private JTextField filterValueField = new JTextField();
    private TitledBorder titledBorder1;
    public JComboBox filterColField = new JComboBox();
    private JPanel cntrChoicePanel = new JPanel();
    private JLabel titlePanelLabel = new JLabel();
    public JRadioButton RBAbsolute = new JRadioButton();
    public JRadioButton RBInterval = new JRadioButton();
    private ButtonGroup RBgroup = new ButtonGroup();
    public JTextField absDateTxt = new JTextField();
    public JTextField intDateTxt = new JTextField();
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel sampleTimeLabel = new JLabel();
    private JLabel counterClearedLabel = new JLabel();
    private JLabel intervalLabel = new JLabel();
    public JTextField intervalTxt = new JTextField();
    private BorderLayout borderLayout2 = new BorderLayout();
    TableCellRenderer myRenderer = new DefaultTableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean isDelta;
            int selectedViewRow = TabularCntrPanel.this.CM.getSelectedViewRow();
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                return comp;
            }
            CountersTableModel ctm = null;
            TableModel model = table.getModel();
            if (model instanceof TableSorter) {
                model = ((TableSorter)model).getTableModel();
            }
            if (model instanceof CountersTableModel) {
                ctm = (CountersTableModel)model;
            }
            boolean showDelta = ctm._cm.showDelta();
            if (value instanceof String) {
                ((JLabel)comp).setHorizontalAlignment(2);
            } else {
                ((JLabel)comp).setHorizontalAlignment(4);
            }
            comp.setForeground(Color.black);
            if (showDelta && (isDelta = ctm._cm.isDeltaCalculatedColumn(column))) {
                boolean isPct = ctm._cm.isPctColumn(column);
                if (isPct) {
                    comp.setForeground(Color.red);
                } else {
                    comp.setForeground(Color.blue);
                    if (((Number)value).intValue() > 0) {
                        comp.setFont(comp.getFont().deriveFont(1));
                    }
                }
            }
            return comp;
        }
    };
    public JTable dataTable = new JTable(){

        public TableCellRenderer getCellRenderer(int row, int column) {
            return TabularCntrPanel.this.myRenderer;
        }
    };
    private JLabel PCTLbl = new JLabel();

    public TabularCntrPanel(String name) {
        try {
            this.jbInit();
            this.titlePanelLabel.setText(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setCounterModel(CountersModel cm) {
        this.CM = cm;
    }

    public void calcColumnWidths() {
        TabularCntrPanel.calcColumnWidths(this.dataTable);
    }

    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        int i = columns.getColumnCount() - 1;
        while (i >= 0) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = c.getPreferredSize().width;
            }
            int row = rowCount - 1;
            while (row >= 0) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width);
                --row;
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
            --i;
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.setMinimumSize(new Dimension(580, 110));
        this.setPreferredSize(new Dimension(580, 110));
        this.cntrChoicePanel.setLayout(this.xYLayout1);
        this.sampleTimeLabel.setHorizontalAlignment(4);
        this.sampleTimeLabel.setText("sampleTime : ");
        this.counterClearedLabel.setToolTipText("");
        this.counterClearedLabel.setHorizontalAlignment(4);
        this.counterClearedLabel.setText("ClearTime : ");
        this.scrollPanel.getViewport().setBackground(new Color(230, 230, 230));
        this.intervalLabel.setHorizontalAlignment(4);
        this.intervalLabel.setText("interval (ms) : ");
        this.intervalTxt.setBorder(BorderFactory.createLoweredBevelBorder());
        this.intervalTxt.setToolTipText("Interval between samples");
        this.intervalTxt.setBackground(Color.lightGray);
        this.RBInterval.setForeground(Color.blue);
        this.RBInterval.setToolTipText("Display 'rate' values (in blue, or red for percentages)");
        this.PCTLbl.setForeground(Color.red);
        this.PCTLbl.setText("or PCT");
        this.dataTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TabularCntrPanel.this.dataTable_mouseClicked(e);
            }
        });
        this.dataTable.setToolTipText("");
        this.filterColField.setToolTipText("For filtering, first, select a column here");
        this.RBAbsolute.setToolTipText("Display absolute values (in black)");
        this.absDateTxt.setToolTipText("Time counters have been cleard");
        this.intDateTxt.setToolTipText("Time of last sample");
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.scrollPanel, "Center");
        this.scrollPanel.getViewport().add((Component)this.dataTable, null);
        this.scrollPanel.setBorder(null);
        this.scrollPanel.setMinimumSize(new Dimension(50, 50));
        this.scrollPanel.setPreferredSize(new Dimension(580, 20));
        this.dataTable.setGridColor(new Color(230, 230, 230));
        this.dataTable.setSelectionMode(0);
        this.dataTable.setAutoResizeMode(0);
        this.headerPanel.setBackground(Color.lightGray);
        this.headerPanel.setDoubleBuffered(false);
        this.headerPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        this.headerPanel.setMinimumSize(new Dimension(580, 90));
        this.headerPanel.setPreferredSize(new Dimension(580, 90));
        this.headerPanel.setLayout(this.headerxYLayout);
        this.filteronLabel.setText("Filter on :");
        this.filterValueLabel.setText("value :");
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Counters");
        this.cntrChoicePanel.add((Component)this.RBAbsolute, new XYConstraints(3, 0, -1, -1));
        this.cntrChoicePanel.add((Component)this.RBInterval, new XYConstraints(3, 27, -1, -1));
        this.cntrChoicePanel.add((Component)this.PCTLbl, new XYConstraints(57, 32, 47, 14));
        this.headerPanel.add((Component)this.cntrChoicePanel, new XYConstraints(232, 1, 112, 87));
        this.headerPanel.add((Component)this.filteronLabel, new XYConstraints(6, 40, -1, 19));
        this.headerPanel.add((Component)this.filterValueLabel, new XYConstraints(6, 64, 43, 19));
        this.headerPanel.add((Component)this.filterColField, new XYConstraints(66, 40, -1, 19));
        this.headerPanel.add((Component)this.filterValueField, new XYConstraints(66, 64, 107, 19));
        this.headerPanel.add((Component)this.absDateTxt, new XYConstraints(428, 5, 153, -1));
        this.headerPanel.add((Component)this.counterClearedLabel, new XYConstraints(360, 5, 68, 21));
        this.headerPanel.add((Component)this.sampleTimeLabel, new XYConstraints(347, 32, 81, 21));
        this.headerPanel.add((Component)this.intDateTxt, new XYConstraints(428, 32, 153, -1));
        this.headerPanel.add((Component)this.intervalLabel, new XYConstraints(347, 59, 81, 21));
        this.headerPanel.add((Component)this.titlePanelLabel, new XYConstraints(2, 3, 221, 23));
        this.headerPanel.add((Component)this.intervalTxt, new XYConstraints(428, 59, 153, -1));
        this.RBAbsolute.setSelected(true);
        this.RBAbsolute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.jRB_actionPerformed(e);
            }
        });
        this.RBInterval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.jRB_actionPerformed(e);
            }
        });
        this.absDateTxt.setBackground(Color.lightGray);
        this.absDateTxt.setBorder(BorderFactory.createLoweredBevelBorder());
        this.intDateTxt.setBackground(Color.lightGray);
        this.intDateTxt.setBorder(BorderFactory.createLoweredBevelBorder());
        this.RBgroup.add(this.RBAbsolute);
        this.RBgroup.add(this.RBInterval);
        this.RBAbsolute.setActionCommand("ABS");
        this.RBInterval.setActionCommand("INT");
        this.filterColField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.filterColField_actionPerformed(e);
            }
        });
        this.filterColField.setMinimumSize(new Dimension(125, 21));
        this.filterValueField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabularCntrPanel.this.filterValueField_actionPerformed(e);
            }
        });
        this.filterValueField.setToolTipText("For filtering, second, enter a value here");
        this.filterValueField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TabularCntrPanel.this.filterValueField_focusLost(e);
            }
        });
        this.cntrChoicePanel.setBackground(Color.lightGray);
        this.cntrChoicePanel.setBorder(this.titledBorder1);
        this.titlePanelLabel.setFont(new Font("Dialog", 1, 16));
        this.RBAbsolute.setBackground(Color.lightGray);
        this.RBAbsolute.setText("Absolute");
        this.RBInterval.setBackground(Color.lightGray);
        this.RBInterval.setText("Rate");
        this.dataTable.getSelectionModel().addListSelectionListener(new tableSelectionHandler());
    }

    void filterColField_actionPerformed(ActionEvent e) {
        if (this.CM == null) {
            return;
        }
        String col = (String)this.filterColField.getSelectedItem();
        this.CM.setColFilter(col);
        try {
            if (!MainFrame.getCnt.isRefreshing()) {
                this.CM.updateTM();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void filterValueField_actionPerformed(ActionEvent e) {
        if (this.CM == null) {
            return;
        }
        String val = this.filterValueField.getText();
        this.CM.setValFilter(val);
        try {
            if (!MainFrame.getCnt.isRefreshing()) {
                this.CM.updateTM();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void filterValueField_focusLost(FocusEvent e) {
        if (this.CM == null) {
            return;
        }
        String val = this.filterValueField.getText();
        this.CM.setValFilter(val);
        try {
            if (!MainFrame.getCnt.isRefreshing()) {
                this.CM.updateTM();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void jRB_actionPerformed(ActionEvent e) {
        if (this.CM == null) {
            return;
        }
        this.CM.displayMode = e.getActionCommand();
        try {
            if (!MainFrame.getCnt.isRefreshing()) {
                this.CM.updateTM();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void dataTable_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.CM.getName().equals("CMprocActivity")) {
            int kpid = this.CM.getSelectedFirstCol();
            ProcessDetailFrame processDetailFrame = new ProcessDetailFrame(kpid);
        }
    }

    class tableSelectionHandler
    implements ListSelectionListener {
        tableSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int firstIndex = e.getFirstIndex();
            boolean isAdjusting = e.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (lsm.isSelectionEmpty()) {
                return;
            }
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            int i = minIndex;
            while (i <= maxIndex) {
                if (lsm.isSelectedIndex(i)) {
                    TabularCntrPanel.this.CM.setSelectedViewRow(i);
                }
                ++i;
            }
        }
    }
}

