/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.Date;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TrendGraph {
    private TimeSeries[] series;
    private XYDataset dataset;
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private ValueAxis timeAxis;
    private NumberAxis valAxis;
    private String graphName;
    private String[] _seriesNames = null;
    private XYPlot plot;
    private boolean pctGraph;
    private Date oldTs = null;
    static /* synthetic */ Class class$0;

    public TrendGraph(String name, String[] seriesNames, boolean pct) {
        this.graphName = name;
        this._seriesNames = seriesNames;
        this.pctGraph = pct;
        this.series = new TimeSeries[1];
        this.dataset = new TimeSeriesCollection(this.series[0]);
        this.timeAxis = new DateAxis(null);
        this.timeAxis.setLowerMargin(0.0);
        this.timeAxis.setUpperMargin(0.0);
        this.valAxis = new NumberAxis(null);
        if (pct) {
            this.valAxis.setRange(0.0, 100.0);
        } else {
            this.valAxis.setRange(0.0, 100.0);
        }
        this.valAxis.setAutoRangeIncludesZero(true);
        this.plot = new XYPlot(this.dataset, this.timeAxis, (ValueAxis)this.valAxis, null);
        this.plot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(2, null, null));
        this.chart = new JFreeChart(name, new Font("Dialog", 1, 14), (Plot)this.plot, true);
        this.chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.cyan));
        this.chartPanel = new ChartPanel(this.chart);
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void addPoint(Date s, Double val) {
        if (s == null) {
            return;
        }
        if (this.oldTs != null && this.oldTs.equals(s)) {
            return;
        }
        this.oldTs = s;
        if (this.series[0] == null) {
            String seriesName = null;
            if (this._seriesNames != null && this._seriesNames.length >= 1) {
                seriesName = this._seriesNames[0];
            }
            if (seriesName == null) {
                seriesName = "Unknown";
            }
            this.series[0] = this.initGraph(seriesName);
        }
        this.series[0].add((RegularTimePeriod)new Second(s), (Number)val);
        if (val == null) {
            return;
        }
        if (val > 0.0 && !this.pctGraph) {
            this.valAxis.setAutoRange(true);
        }
    }

    public void addPoint(Date s, Double[] val) {
        this.addPoint(s, val, null);
    }

    public void addPoint(Date s, Double[] val, String[] name) {
        if (s == null) {
            return;
        }
        if (this.oldTs != null && this.oldTs.equals(s)) {
            return;
        }
        this.oldTs = s;
        if (val.length > this.series.length) {
            System.out.println("DEBUG: Resize the series array from " + this.series.length + " to " + val.length + ".");
            TimeSeries[] prevSeries = this.series;
            this.series = new TimeSeries[val.length];
            System.arraycopy(prevSeries, 0, this.series, 0, prevSeries.length);
            System.out.println("DEBUG: AFTER Resize the series array is " + this.series.length + ".");
        }
        int i = 0;
        while (i < val.length) {
            if (this.series[i] == null) {
                String seriesName = null;
                if (this._seriesNames != null && this._seriesNames.length > i) {
                    seriesName = this._seriesNames[i];
                }
                if (seriesName == null && name != null && name.length > i) {
                    seriesName = name[i];
                }
                if (seriesName == null) {
                    seriesName = "Unknown";
                }
                this.series[i] = this.initGraph(seriesName);
            }
            this.series[i].add((RegularTimePeriod)new Second(s), (Number)val[i]);
            if (val[i] != null && val[i] > 0.0 && !this.pctGraph) {
                this.valAxis.setAutoRange(true);
            }
            ++i;
        }
    }

    public void clearGraph() {
        ((TimeSeriesCollection)this.dataset).removeAllSeries();
        int i = 0;
        while (i < this.series.length) {
            this.series[i] = null;
            ++i;
        }
    }

    private TimeSeries initGraph(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Second");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries ts = new TimeSeries(name, (Class)clazz);
        ts.setMaximumItemCount(120);
        ((TimeSeriesCollection)this.dataset).addSeries(ts);
        long pointTime = System.currentTimeMillis() / 5000L * 5000L;
        pointTime -= 600000L;
        Double value = new Double(0.0);
        int i = 0;
        while (i < 120) {
            ts.add((RegularTimePeriod)new Second(new Date(pointTime)), (Number)value);
            pointTime += 5000L;
            ++i;
        }
        return ts;
    }
}

