/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.AdvancedPanel;
import com.sybase.ase.planviewer.Column;
import com.sybase.ase.planviewer.Constants;
import com.sybase.ase.planviewer.ExplorerTreeCellRenderer;
import com.sybase.ase.planviewer.Index;
import com.sybase.ase.planviewer.MyComboBoxRenderer;
import com.sybase.ase.planviewer.ProgressPanel;
import com.sybase.ase.planviewer.Table;
import com.sybase.ase.planviewer.XMLListView;
import com.sybase.ase.planviewer.XMLMetaTablet;
import com.sybase.ase.planviewer.XMLModelBuilder;
import com.sybase.ase.planviewer.XMLModelNode;
import com.sybase.ase.planviewer.XMLTablet;
import com.sybase.ase.planviewer.XMLTreeView;
import com.sybase.ase.planviewer.XMLViewNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ASEPlanViewer
extends JPanel
implements TreeSelectionListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JSplitPane _splitPaneVertical;
    private JSplitPane _splitPaneHorizontal;
    private XMLTreeView _treePanel;
    private XMLListView _listPanel;
    private AdvancedPanel _advancedPanel;
    private JTree _explorerTree;
    private JTabbedPane _detailTabbedPane;
    private JEditorPane _xhtmlPane;
    private ProgressPanel _progressPanel;
    private JTextArea _xmlPane;
    private JTextArea _textPane;
    private JComboBox _comboBox;
    private StringBuffer _sbASEXML;
    private StringBuffer _sbPVDXSL = null;
    private boolean _blnStopTreeNodeChangeEvent;
    private static String _sCopyright = null;
    private static String _sVersion = null;
    private boolean _blnShowExecIO = true;
    private boolean _blnShowExec = false;
    private boolean _blnShowOpt = false;
    private PrintWriter _debugWriter = null;
    private Connection _con;
    private String _error;
    private static Thread _workerThread;
    private ResourceBundle _res;
    private static boolean _cancelPlan;
    public static final int LIO_WEIGHT = 2;
    public static final int PIO_WEIGHT = 25;
    public static final double CPU_WEIGHT = 0.1;

    public void cancelPlan() {
        _cancelPlan = true;
    }

    public ASEPlanViewer(Connection connection) throws Exception {
        this();
        this._con = connection;
        this._advancedPanel.setConnection(this._con);
    }

    private ASEPlanViewer() throws Exception {
        super(new GridBagLayout());
        this.createExplorerTree();
        this._progressPanel = new ProgressPanel(this);
        this._treePanel = new XMLTreeView();
        this._listPanel = new XMLListView(this);
        this._advancedPanel = new AdvancedPanel(this);
        this._listPanel.showTreeElementsAsList((DefaultMutableTreeNode)this._explorerTree.getModel().getRoot());
        this._listPanel.setListMouseSelectionListener(this);
        this._comboBox = new JComboBox();
        this._comboBox.addActionListener(this);
        this._comboBox.setRenderer(new MyComboBoxRenderer());
        this._comboBox.setPreferredSize(new Dimension(300, 205));
        this._comboBox.setVisible(false);
        this._detailTabbedPane = new JTabbedPane(3);
        this._xmlPane = new JTextArea();
        this._xmlPane.setEditable(false);
        this._textPane = new JTextArea();
        this._textPane.setEditable(false);
        this._xhtmlPane = new JEditorPane();
        this._xhtmlPane.setEditorKit(new HTMLEditorKit());
        this._xhtmlPane.setEditable(false);
        this._detailTabbedPane.addTab(this.getLocalizedMessage("XHTML_TAB_TITLE"), Constants.XHTML_TAB_IMAGE, new JScrollPane(this._xhtmlPane));
        this._detailTabbedPane.addTab(this.getLocalizedMessage("XML_TAB_TITLE"), Constants.XML_TAB_IMAGE, new JScrollPane(this._xmlPane));
        this._detailTabbedPane.addTab(this.getLocalizedMessage("TEXT_TAB_TITLE"), Constants.TEXT_TAB_IMAGE, new JScrollPane(this._textPane));
        this._detailTabbedPane.addTab(this.getLocalizedMessage("ADVANCED_TAB_TITLE"), Constants.PV_IMAGE, new JScrollPane(this._advancedPanel));
        this._splitPaneVertical = new JSplitPane(0, new JScrollPane(this._treePanel), this._detailTabbedPane);
        this._splitPaneVertical.setDividerLocation(220);
        this._splitPaneVertical.setResizeWeight(0.5);
        this._splitPaneVertical.setDividerSize(10);
        this._splitPaneVertical.setOneTouchExpandable(true);
        this._splitPaneHorizontal = new JSplitPane(1, new JScrollPane(this._explorerTree), this._splitPaneVertical);
        this.showExplorerTree();
        this._splitPaneHorizontal.setOneTouchExpandable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        this.add((Component)this._progressPanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this._comboBox, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridy = 1;
        this.add((Component)this._splitPaneHorizontal, gridBagConstraints);
        this.readXSLInString();
        this.setVisible(true);
        try {
            String string = ASEPlanViewer.getVersionString();
            int n = string.indexOf("DEBUG");
            if (n != -1) {
                string = (string = string.substring(n + 5).trim()).length() > 0 ? string : null;
            }
            this._debugWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            this.debugPrint("Adaptive Server Enterprise Graphical Plan Viewer Debugger \nStarted at " + this.getCurrentTime());
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showProgressPanel(boolean bl) {
        this._progressPanel.setShowHide(bl, this._error);
        this._comboBox.setVisible(this._comboBox.getItemCount() > 1 && !bl);
        this._splitPaneHorizontal.setVisible(!bl);
    }

    public Connection getConnection() {
        return this._con;
    }

    public String getLocalizedMessage(String string) {
        if (this._res == null) {
            try {
                this._res = ResourceBundle.getBundle("com.sybase.ase.planviewer.res.PVResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._res.getString(string);
    }

    protected void finalize() {
        if (this._debugWriter != null) {
            this.debugPrint("Adaptive Server Enterprise Graphical Plan Viewer Debugger\nEnded at " + this.getCurrentTime());
            this._debugWriter.close();
        }
        this._debugWriter = null;
    }

    public void setShowExecIO(boolean bl) {
        this._blnShowExecIO = bl;
        this.showExplorerTree();
    }

    public boolean canShowExecIO() {
        return this._blnShowExecIO;
    }

    public void setShowExec(boolean bl) {
        this._blnShowExec = bl;
        this.showExplorerTree();
    }

    public boolean canShowExec() {
        return this._blnShowExec;
    }

    public void setShowOpt(boolean bl) {
        this._blnShowOpt = bl;
        this.showExplorerTree();
    }

    public boolean canShowOpt() {
        return this._blnShowOpt;
    }

    private void showExplorerTree() {
        if (this.canShowOpt() || this.canShowExec() & this.canShowExecIO()) {
            this._splitPaneHorizontal.setDividerLocation(220);
            this._splitPaneHorizontal.setDividerSize(10);
        } else {
            this._splitPaneHorizontal.setDividerLocation(0);
            this._splitPaneHorizontal.setDividerSize(0);
        }
    }

    private void createExplorerTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new XMLTablet(this.getLocalizedMessage("TITLE"), 1, this.getLocalizedMessage("TITLE"), this));
        this._explorerTree = new JTree(defaultMutableTreeNode);
        this._explorerTree.setRootVisible(true);
        this._explorerTree.setShowsRootHandles(true);
        this._explorerTree.setEditable(false);
        this._explorerTree.getSelectionModel().setSelectionMode(1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new XMLTablet("Execution IO", 10, "Emit", this));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new XMLTablet("Execution", 20, "Emit", this));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new XMLTablet("Optimizer", 30, "Optimizer-Trace", this));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new XMLTablet("Logical Operator Tree", 301, "LopTree", this));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new XMLTablet("Blocks", 313, "Blocks", this), true);
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new XMLTablet("Managers", 302, "Managers", this));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new XMLTablet("Logical Properties", 303, "Logical-Properties", this));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new XMLTablet("Parallel", 304, "Parallel", this));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new XMLTablet("Histogram", 305, "Histogram", this));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new XMLTablet("Abstract", 306, "Abstract", this));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new XMLTablet("Search Engine", 307, "Search-Engine", this));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new XMLTablet("Counters", 308, "Counters", this));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new XMLTablet("Best", 309, "Emit", this));
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new XMLTablet("Physical IO Costing", 310, "Physical-IO-Costing", this));
        DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode(new XMLTablet("Logical IO Costing", 311, "Logical-IO-Costing", this));
        DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode(new XMLTablet("Elimination", 312, "Elimination", this));
        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        defaultMutableTreeNode4.add(defaultMutableTreeNode6);
        defaultMutableTreeNode4.add(defaultMutableTreeNode7);
        defaultMutableTreeNode4.add(defaultMutableTreeNode8);
        defaultMutableTreeNode4.add(defaultMutableTreeNode9);
        defaultMutableTreeNode4.add(defaultMutableTreeNode10);
        defaultMutableTreeNode4.add(defaultMutableTreeNode11);
        defaultMutableTreeNode4.add(defaultMutableTreeNode12);
        defaultMutableTreeNode4.add(defaultMutableTreeNode13);
        defaultMutableTreeNode4.add(defaultMutableTreeNode14);
        defaultMutableTreeNode4.add(defaultMutableTreeNode15);
        defaultMutableTreeNode4.add(defaultMutableTreeNode16);
        defaultMutableTreeNode4.add(defaultMutableTreeNode17);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this._explorerTree.setCellRenderer(new ExplorerTreeCellRenderer());
        this._explorerTree.addTreeSelectionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._blnStopTreeNodeChangeEvent = true;
        XMLMetaTablet xMLMetaTablet = (XMLMetaTablet)this._comboBox.getSelectedItem();
        this._comboBox.setToolTipText(xMLMetaTablet.getToolTipForComboBox());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._explorerTree.getModel().getRoot();
        this.collapseAll(defaultMutableTreeNode);
        if (this.canShowExecIO()) {
            this._blnStopTreeNodeChangeEvent = false;
            this.clickExecIOInTree(defaultMutableTreeNode);
        } else {
            this.showListOnDetailsPanel(defaultMutableTreeNode);
        }
        this._blnStopTreeNodeChangeEvent = false;
    }

    private void clickExecIOInTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
        this._explorerTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    private void collapseAll(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this._explorerTree.isExpanded(new TreePath(defaultMutableTreeNode2.getPath()))) continue;
            this.collapseAll(defaultMutableTreeNode2);
        }
        this._explorerTree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n;
        JTable jTable = this._listPanel.getJTable();
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        if (mouseEvent.getClickCount() == 2 && (n = jTable.getSelectedRow()) >= 0 && (defaultMutableTreeNode = (DefaultMutableTreeNode)jTable.getValueAt(n, 0)) != null) {
            if (defaultMutableTreeNode.getUserObject() instanceof Column || defaultMutableTreeNode.getUserObject() instanceof Index) {
                mouseEvent.consume();
            } else {
                this._explorerTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this._blnStopTreeNodeChangeEvent) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._explorerTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof XMLTablet) {
            int n;
            Object object;
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            XMLTablet xMLTablet = (XMLTablet)defaultMutableTreeNode.getUserObject();
            int n2 = xMLTablet.getId();
            try {
                if (n2 == 1) {
                    this._listPanel.showTreeElementsAsList(defaultMutableTreeNode);
                    this._splitPaneVertical.setTopComponent(new JScrollPane(this._listPanel));
                    this._splitPaneVertical.setBottomComponent(null);
                    return;
                }
                object2 = (XMLMetaTablet)this._comboBox.getSelectedItem();
                if (n2 == 10) {
                    object = ((XMLMetaTablet)object2).getEioXMLTablet();
                    defaultMutableTreeNode2 = this.build(this._sbASEXML, (XMLTablet)object);
                    if (((XMLModelNode)defaultMutableTreeNode2).getAdvancedInfo() != null) {
                        this._advancedPanel.build(((XMLModelNode)defaultMutableTreeNode2).getAdvancedInfo());
                        this._advancedPanel.revalidate();
                    } else {
                        n = this._detailTabbedPane.indexOfTab(this.getLocalizedMessage("ADVANCED_TAB_TITLE"));
                        if (n != -1) {
                            this._detailTabbedPane.removeTabAt(n);
                            this._detailTabbedPane.revalidate();
                        }
                    }
                    this._xmlPane.setText(this._sbASEXML.substring(((XMLTablet)object).getStartOffset(), ((XMLTablet)object).getEndOffset()).toString());
                    this._xmlPane.setCaretPosition(0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            switch (n2) {
                case 10: 
                case 20: 
                case 301: 
                case 309: {
                    this.showXMLTreeOnDetailsPanel();
                    break;
                }
                case 30: {
                    this.showListOnDetailsPanel(defaultMutableTreeNode);
                    break;
                }
                case 313: {
                    defaultMutableTreeNode.removeAllChildren();
                    object2 = defaultMutableTreeNode2.children();
                    object = new ArrayList();
                    while (object2.hasMoreElements()) {
                        ((ArrayList)object).add(object2.nextElement());
                    }
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        defaultMutableTreeNode.add((DefaultMutableTreeNode)((ArrayList)object).get(n));
                    }
                    this.showListOnDetailsPanel(defaultMutableTreeNode);
                    break;
                }
                default: {
                    this.showFeatureAvailableSoon();
                    break;
                }
            }
        } else {
            this.showListOnDetailsPanel(defaultMutableTreeNode);
        }
    }

    private void showXMLTreeOnDetailsPanel() {
    }

    private void showFeatureAvailableSoon() {
        this._splitPaneVertical.setTopComponent(new JLabel("<html><h1><font color=\"blue\">This feature will be available soon . . .</font></h1></html>", 0));
        this._splitPaneVertical.setBottomComponent(null);
    }

    private void showListOnDetailsPanel(DefaultMutableTreeNode defaultMutableTreeNode) {
        this._listPanel.showTreeElementsAsList(defaultMutableTreeNode);
        this._splitPaneVertical.setTopComponent(new JScrollPane(this._listPanel));
        this._splitPaneVertical.setBottomComponent(null);
    }

    public void setXML(StringBuffer stringBuffer) {
        int n = stringBuffer.indexOf("<");
        if (n == -1) {
            this._sbASEXML = null;
            return;
        }
        stringBuffer.replace(0, n, "");
        n = stringBuffer.lastIndexOf(">");
        if (n == -1) {
            this._sbASEXML = null;
            return;
        }
        stringBuffer.replace(n + 1, stringBuffer.length(), "");
        this._sbASEXML = stringBuffer;
    }

    private void debugPrint(String string) {
        if (this._debugWriter != null) {
            this._debugWriter.println(string);
        }
    }

    private void generatePlanFromFile(String string) throws Exception {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") != -1) {
                bl = true;
            }
            if (string2.indexOf("</query") != -1) {
                stringBuffer.append(string2);
                bl = false;
            }
            if (!bl) continue;
            stringBuffer.append(string2 + "\n");
        }
        this.generatePlan(stringBuffer, null);
    }

    public void generatePlan(final StringBuffer stringBuffer, final StringBuffer stringBuffer2) throws Exception {
        this.showProgressPanel(true);
        if (stringBuffer == null || stringBuffer.toString().trim().length() < "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length()) {
            this._error = "The Viewer is unable to generate plan.\nPlease check whether the SQL statement is valid.\nPlan Viewer Error - Empty XML";
            this.showProgressPanel(true);
            return;
        }
        this._error = null;
        if (_workerThread != null) {
            _workerThread.interrupt();
            _workerThread = null;
            this._error = null;
            this.showProgressPanel(true);
        }
        _workerThread = new Thread(){

            @Override
            public void run() {
                try {
                    int n;
                    ASEPlanViewer.this.debugPrint("XML=\n" + stringBuffer.toString() + "\n");
                    ASEPlanViewer.this.debugPrint("Show Plan Text=\n" + stringBuffer2 + "\n");
                    if (ASEPlanViewer.this._debugWriter != null) {
                        ASEPlanViewer.this._debugWriter.flush();
                    }
                    Date date = new Date();
                    String string = "";
                    _cancelPlan = false;
                    if (stringBuffer2 != null) {
                        ASEPlanViewer.this._textPane.setText(stringBuffer2.toString());
                        ASEPlanViewer.this._textPane.setCaretPosition(0);
                    }
                    ASEPlanViewer.this.setXML(stringBuffer);
                    if (ASEPlanViewer.this._sbASEXML == null || ASEPlanViewer.this._sbASEXML.length() < "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length()) {
                        ASEPlanViewer.this._error = "Empty XML";
                        ASEPlanViewer.this.showProgressPanel(true);
                        _workerThread = null;
                        return;
                    }
                    if (_workerThread.isInterrupted()) {
                        ASEPlanViewer.this._error = "The Current Plan Generation was interrupted by a new request 2";
                        ASEPlanViewer.this.showProgressPanel(true);
                        _workerThread = null;
                        return;
                    }
                    Vector vector = ASEPlanViewer.this.getXMLTablets(stringBuffer);
                    Date date2 = new Date();
                    ASEPlanViewer.this.debugPrint("Building Index table of each xml start, end took : " + ASEPlanViewer.this.getTimeTaken(date, date2));
                    string = "Start Time  = " + ASEPlanViewer.this.getCurrentTime();
                    Vector<XMLMetaTablet> vector2 = new Vector<XMLMetaTablet>();
                    double d = 0.0;
                    for (n = 0; n < vector.size() && !_workerThread.isInterrupted() && !_cancelPlan; ++n) {
                        int n2;
                        XMLMetaTablet xMLMetaTablet = new XMLMetaTablet();
                        XMLTablet xMLTablet = (XMLTablet)vector.elementAt(n);
                        String string2 = "";
                        int n3 = ASEPlanViewer.this._sbASEXML.indexOf("<text", xMLTablet.getStartOffset());
                        if (n3 == -1) {
                            xMLTablet.setSQL(null);
                        } else {
                            n2 = ASEPlanViewer.this._sbASEXML.indexOf("</text", n3 += 6);
                            string2 = ASEPlanViewer.this._sbASEXML.substring(n3, n2);
                            n3 = string2.indexOf("SQL Text:");
                            if (n3 == -1) {
                                xMLTablet.setSQL(null);
                            } else {
                                n2 = string2.indexOf("]]>");
                                string2 = string2.substring(n3 += "SQL Text:".length(), n2).trim();
                                xMLTablet.setSQL(string2);
                            }
                        }
                        n2 = ASEPlanViewer.this._sbASEXML.indexOf("<costs", xMLTablet.getStartOffset());
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        if (n2 != -1 && n2 < xMLTablet.getEndOffset()) {
                            int n4;
                            int n5 = ASEPlanViewer.this._sbASEXML.indexOf("</costs", n2 += 7);
                            String string3 = ASEPlanViewer.this._sbASEXML.substring(n2, n5);
                            int n6 = string3.indexOf("<lio");
                            if (n6 == -1) {
                                d2 = 0.0;
                            } else {
                                n6 += 5;
                                n4 = string3.indexOf("</lio");
                                try {
                                    d2 = Double.parseDouble(string3.substring(n6, n4).trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ASEPlanViewer.this.debugPrint(numberFormatException.getLocalizedMessage());
                                    d2 = 0.0;
                                }
                            }
                            n4 = string3.indexOf("<pio");
                            if (n4 == -1) {
                                d3 = 0.0;
                            } else {
                                n4 += 5;
                                int n7 = string3.indexOf("</pio");
                                try {
                                    d3 = Double.parseDouble(string3.substring(n4, n7).trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ASEPlanViewer.this.debugPrint(numberFormatException.getLocalizedMessage());
                                    d3 = 0.0;
                                }
                            }
                            int n8 = string3.indexOf("<cpu");
                            if (n8 == -1) {
                                d4 = 0.0;
                            } else {
                                n8 += 5;
                                int n9 = string3.indexOf("</cpu");
                                try {
                                    d4 = Double.parseDouble(string3.substring(n8, n9).trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ASEPlanViewer.this.debugPrint(numberFormatException.getLocalizedMessage());
                                    d4 = 0.0;
                                }
                            }
                        }
                        xMLTablet.setAggregatedCostFromXML(25.0 * d3 + 2.0 * d2 + 0.1 * d4);
                        ASEPlanViewer.this.debugPrint("P, L, C, T : (" + d3 + ", " + d2 + ", " + d4 + ", " + xMLTablet.getAggregatedCostFromXML() + ") SQL: " + string2);
                        xMLMetaTablet.addTablet(xMLTablet);
                        d += xMLTablet.getAggregatedCostFromXML();
                        ASEPlanViewer.this.debugPrint("Built One XML in :" + ASEPlanViewer.this.getTimeTaken(date2, new Date()));
                        date2 = new Date();
                        vector2.add(ASEPlanViewer.this.getSortedElementIndex(vector2, false, xMLTablet.getAggregatedCostFromXML()), xMLMetaTablet);
                        ASEPlanViewer.this.debugPrint("Added into Sorted List of XMLs in : " + ASEPlanViewer.this.getTimeTaken(date2, new Date()));
                        date2 = new Date();
                    }
                    boolean bl = d == 0.0;
                    double d5 = 0.0;
                    if (bl) {
                        vector2.clear();
                        for (n = 0; n < vector.size() && !_workerThread.isInterrupted() && !_cancelPlan; ++n) {
                            XMLMetaTablet xMLMetaTablet = new XMLMetaTablet();
                            XMLTablet xMLTablet = (XMLTablet)vector.elementAt(n);
                            xMLTablet.setOldASE(true);
                            ASEPlanViewer.this.build(xMLTablet);
                            xMLMetaTablet.addTablet(xMLTablet);
                            d5 += xMLTablet.getCost();
                            vector2.add(ASEPlanViewer.this.getSortedElementIndex(vector2, true, xMLTablet.getCost()), xMLMetaTablet);
                        }
                    }
                    ASEPlanViewer.this.debugPrint("Building Index table of each xml start, end in : " + ASEPlanViewer.this.getTimeTaken(date2, new Date()));
                    if (_workerThread.isInterrupted()) {
                        ASEPlanViewer.this._error = "The Current Plan Generation was interrupted by a new request 3";
                        ASEPlanViewer.this.showProgressPanel(true);
                        _workerThread = null;
                        return;
                    }
                    ASEPlanViewer.this.setCostPercentages(vector2, bl, bl ? d5 : d);
                    ASEPlanViewer.this.debugPrint("Set Cost Percentages for all xmls in : " + ASEPlanViewer.this.getTimeTaken(date2, new Date()));
                    ASEPlanViewer.this._comboBox.setModel(new DefaultComboBoxModel(vector2));
                    ASEPlanViewer.this._comboBox.setSelectedIndex(0);
                    ASEPlanViewer.this._splitPaneHorizontal.setDividerLocation(0);
                    ASEPlanViewer.this._splitPaneHorizontal.setEnabled(false);
                    ASEPlanViewer.this.debugPrint("End Time    = " + ASEPlanViewer.this.getCurrentTime());
                    ASEPlanViewer.this.debugPrint(string);
                    Date date3 = new Date();
                    ASEPlanViewer.this.debugPrint("Total Time  = " + ASEPlanViewer.this.getTimeTaken(date, date3));
                    ASEPlanViewer.this.debugPrint("No. of XMLs = " + vector.size() + "/" + ASEPlanViewer.this._comboBox.getItemCount());
                    ASEPlanViewer.this.debugPrint(ASEPlanViewer.getVersionString());
                    if (ASEPlanViewer.this._debugWriter != null) {
                        ASEPlanViewer.this._debugWriter.flush();
                    }
                    ASEPlanViewer.this.showProgressPanel(false);
                    _workerThread = null;
                    ASEPlanViewer.this.revalidate();
                }
                catch (Exception exception) {
                    ASEPlanViewer.this._error = exception.getLocalizedMessage();
                    _workerThread = null;
                    ASEPlanViewer.this.showProgressPanel(true);
                }
            }
        };
        _workerThread.start();
    }

    private int getSortedElementIndex(Vector vector, boolean bl, double d) {
        int n = 0;
        for (n = 0; n < vector.size() && !(bl ? d > ((XMLMetaTablet)vector.elementAt(n)).getEioXMLTablet().getCost() : d > ((XMLMetaTablet)vector.elementAt(n)).getEioXMLTablet().getAggregatedCostFromXML()); ++n) {
        }
        return n;
    }

    private void setCostPercentages(Vector vector, boolean bl, double d) {
        for (int i = 0; i < vector.size(); ++i) {
            XMLTablet xMLTablet = ((XMLMetaTablet)vector.elementAt(i)).getEioXMLTablet();
            if (d == 0.0) {
                if (bl) {
                    xMLTablet.setCostPercent(0.0);
                    continue;
                }
                xMLTablet.setAggregatedCostPercentFromXML(0.0);
                continue;
            }
            if (bl) {
                xMLTablet.setCostPercent(new Double(xMLTablet.getCost() / d));
                continue;
            }
            xMLTablet.setAggregatedCostPercentFromXML(new Double(xMLTablet.getAggregatedCostFromXML() / d));
        }
    }

    private XMLModelNode build(StringBuffer stringBuffer, XMLTablet xMLTablet) throws Exception {
        XMLModelBuilder xMLModelBuilder = new XMLModelBuilder(this, xMLTablet);
        XMLModelNode xMLModelNode = xMLModelBuilder.build(stringBuffer);
        this._treePanel.build(this, xMLModelNode);
        this._treePanel.revalidate();
        return xMLModelNode;
    }

    private XMLModelNode build(XMLTablet xMLTablet) throws Exception {
        XMLModelNode xMLModelNode = null;
        this._comboBox.setVisible(false);
        xMLModelNode = new XMLModelBuilder(this, xMLTablet).build(this._sbASEXML);
        if (xMLModelNode.getAdvancedInfo() != null) {
            this._advancedPanel.build(xMLModelNode.getAdvancedInfo());
            this._advancedPanel.revalidate();
        } else {
            this._advancedPanel.setVisible(false);
        }
        this._treePanel.build(this, xMLModelNode);
        this._treePanel.revalidate();
        xMLModelNode.getViewNode().getButton().doClick();
        return xMLModelNode;
    }

    private void setDecoratedXMLText(String string) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append("<body>");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\t", "&nbsp;&nbsp;");
        string = string.replaceAll("\n", "<br>");
        string = string.replaceAll("&lt;", "</strong><font color=\"red\">&lt;</font><font color=\"blue\">");
        string = string.replaceAll("&gt;", "</font><font color=\"red\">&gt;</font><strong>");
        stringBuffer.append(string).append("</body>").append("</html>");
        this._xmlPane.setText(stringBuffer.toString());
        this._xmlPane.setCaretPosition(0);
    }

    public JPanel getPanel() {
        return this;
    }

    public void readXSLInString() throws Exception {
        if (this._sbPVDXSL != null) {
            return;
        }
        this._sbPVDXSL = new StringBuffer();
        URL uRL = ASEPlanViewer.class.getResource("res/stylesheet.xsl");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            this._sbPVDXSL.append(string).append("\n");
        }
        bufferedReader.close();
    }

    private String stripHTMLFromNodeLabel(String string) {
        String string2 = string;
        string2 = string2.replaceAll("<html>", "");
        string2 = string2.replaceAll("</html>", "");
        string2 = string2.replaceAll("<strong>", "");
        string2 = string2.replaceAll("</strong>", "");
        string2 = string2.replaceAll("</br>", "");
        string2 = string2.replaceAll("<br>", "&#160;");
        return string2;
    }

    public void scrollToNode(XMLViewNode xMLViewNode) throws Exception {
        if (xMLViewNode.getToolTipText() != null) {
            this._xhtmlPane.setText(xMLViewNode.getToolTipText());
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._explorerTree.getLastSelectedPathComponent();
        String string = this._sbASEXML.toString();
        boolean bl = !xMLViewNode.getModelNode().isLeaf();
        string = xMLViewNode.getModelNode().getXMLTablet().getSubString(string);
        int n = this._sbPVDXSL.indexOf("<xsl:variable name=\"root\" select=\"");
        int n2 = this._sbPVDXSL.indexOf("\"/>", n += "<xsl:variable name=\"".length() + "root\" select=\"".length());
        String string2 = xMLViewNode.getModelNode().getXPath();
        this._sbPVDXSL.replace(n, n2, string2);
        n = this._sbPVDXSL.indexOf("<xsl:variable name=\"node");
        n2 = this._sbPVDXSL.indexOf("</xsl:variable>", n += "<xsl:variable name=\"".length() + "node".length() + 2);
        this._sbPVDXSL.replace(n, n2, this.stripHTMLFromNodeLabel(xMLViewNode.getButton().getText()));
        n = this._sbPVDXSL.indexOf("<xsl:variable name=\"showSubTreeStatistics");
        n2 = this._sbPVDXSL.indexOf("</xsl:variable>", n += "<xsl:variable name=\"".length() + "showSubTreeStatistics".length() + 2);
        this._sbPVDXSL.replace(n, n2, bl + "");
        StreamSource streamSource = new StreamSource(new StringReader(string));
        StreamSource streamSource2 = new StreamSource(new StringReader(this._sbPVDXSL.toString()));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource2);
        StringWriter stringWriter = new StringWriter();
        try {
            transformer.transform(streamSource, new StreamResult(stringWriter));
        }
        catch (Exception exception) {
            stringWriter.write(exception.getLocalizedMessage());
        }
        this._xhtmlPane.setText(stringWriter.toString());
        Color color = this.getColorScheme(this._xhtmlPane.getText());
        if (color != null) {
            xMLViewNode.setBackground(color);
        }
        xMLViewNode._button.setToolTipText(this._xhtmlPane.getText());
        ToolTipManager.sharedInstance().setDismissDelay(100000);
    }

    private Color getColorScheme(String string) {
        if (string.trim().equals("")) {
            return null;
        }
        String string2 = string;
        int n = string2.indexOf("Subtree Statistics");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if (string2.indexOf("#ff0000") != -1) {
            return Color.RED;
        }
        if (string2.indexOf("#cc9933") != -1) {
            return Color.ORANGE;
        }
        return null;
    }

    private Vector getXMLTablets(StringBuffer stringBuffer) throws Exception {
        Vector<XMLTablet> vector = new Vector<XMLTablet>();
        long l = 0L;
        long l2 = 0L;
        while ((l = (long)stringBuffer.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (int)l2)) != -1L) {
            l2 = stringBuffer.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (int)l + 1);
            if (l2 < 0L) {
                l2 = stringBuffer.length();
            }
            XMLTablet xMLTablet = stringBuffer.substring((int)l, (int)l2).indexOf("query") != -1 ? new XMLTablet("Execution IO", 10, "Emit", this) : new XMLTablet("Optimizer", 30, "Optimizer-Trace", this);
            xMLTablet.setStartOffset((int)l);
            xMLTablet.setEndOffset((int)l2);
            vector.addElement(xMLTablet);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("\nUsage: planviewer [ -v | xml filename ]");
            System.exit(-1);
        } else if (stringArray[0].toLowerCase().startsWith("-v")) {
            try {
                System.out.println(ASEPlanViewer.getFullVersionString());
                System.exit(0);
            }
            catch (Exception exception) {
                System.out.println("Sybase ASE Plan Viewer Utility");
                System.exit(-1);
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        Window window = null;
        try {
            ASEPlanViewer aSEPlanViewer = new ASEPlanViewer();
            window = new JFrame(aSEPlanViewer.getLocalizedMessage("TITLE"));
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            aSEPlanViewer.generatePlanFromFile(stringArray[0]);
            ((JFrame)window).getContentPane().add((Component)aSEPlanViewer, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        window.setSize(800, 600);
        window.setVisible(true);
    }

    public static String getFullVersionString() throws ClassNotFoundException, LinkageError, ExceptionInInitializerError, NullPointerException, IOException, ParseException, FileNotFoundException {
        if (_sCopyright == null) {
            ASEPlanViewer.getCopyrightString();
        }
        if (_sVersion == null) {
            ASEPlanViewer.getVersionString();
        }
        return _sVersion + _sCopyright;
    }

    public static String getVersionString() throws ClassNotFoundException, LinkageError, ExceptionInInitializerError, NullPointerException, IOException, ParseException, FileNotFoundException {
        if (_sVersion != null) {
            return _sVersion;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = Class.forName("com.sybase.ase.planviewer.ASEPlanViewer");
        URL uRL = clazz.getResource("res/version.txt");
        if (uRL != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = bufferedReader.readLine();
            stringBuffer.append("\n").append(string).append("\n");
            bufferedReader.close();
        }
        _sVersion = stringBuffer.toString();
        return _sVersion;
    }

    public String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy kk:mm:ss z", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    public String getTimeTaken(Date date, Date date2) {
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar.setTime(date);
            calendar2.setTime(date2);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            n = calendar2.get(13) - calendar.get(13);
            if (n < 0) {
                n += 60;
                --n2;
            }
            if ((n2 += calendar2.get(12) - calendar.get(12)) < 0) {
                n2 += 60;
                --n3;
            }
            if ((n3 += calendar2.get(11) - calendar.get(11)) < 0) {
                n3 += 24;
                --n4;
            }
            if ((n4 += calendar2.get(5) - calendar.get(5)) < 0) {
                n4 += 30;
                --n5;
            }
            if ((n5 += calendar2.get(2) - calendar.get(2)) < 0) {
                n5 += 12;
                --n6;
            }
            return this.format(n5) + "/" + this.format(n4) + "/" + this.format(n6 += calendar2.get(1) - calendar.get(1)) + " " + this.format(n3) + ":" + this.format(n2) + ":" + this.format(n);
        }
        catch (Exception exception) {
            this.debugPrint(exception.getMessage());
            return "";
        }
    }

    private String format(int n) {
        String string = String.valueOf(n);
        if (string.length() < 2) {
            return "0" + n;
        }
        return string;
    }

    public static String getCopyrightString() throws ClassNotFoundException, LinkageError, ExceptionInInitializerError, NullPointerException, IOException, FileNotFoundException {
        if (_sCopyright != null) {
            return _sCopyright;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = Class.forName("com.sybase.ase.planviewer.ASEPlanViewer");
        String string = Locale.getDefault().toString();
        if (string == null) {
            string = "en_US";
        } else if (string.length() == 2) {
            string = string + "_US";
        }
        URL uRL = clazz.getResource("res/copyright_" + string + ".txt");
        if (uRL != null) {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append("\n" + string2);
            }
            bufferedReader.close();
        }
        _sCopyright = stringBuffer.toString();
        return _sCopyright;
    }

    public static void commonRenderer(JLabel jLabel, Object object, int n) {
        if (n == 0) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode != null && (object2 = defaultMutableTreeNode.getUserObject()) != null) {
                if (object2 instanceof XMLTablet) {
                    XMLTablet xMLTablet = (XMLTablet)object2;
                    int n2 = xMLTablet.getId();
                    if (n2 == 1 || n2 == 10 || n2 == 301 || n2 == 30) {
                        jLabel.setIcon(Constants.PV_IMAGE);
                    } else {
                        jLabel.setIcon(null);
                    }
                } else if (object2 instanceof Table && ((Table)object2).isTable()) {
                    jLabel.setIcon(Constants.TABLE_IMAGE);
                } else if (object2 instanceof Index) {
                    jLabel.setIcon(Constants.INDEX_IMAGE);
                } else if (object2 instanceof Column) {
                    jLabel.setIcon(Constants.COL_IMAGE);
                }
            }
        } else {
            jLabel.setIcon(null);
        }
    }
}

