/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisTickPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.axistickpainters.AxisTickPainterDefault;
import info.monitorenter.gui.chart.events.Chart2DActionPrintSingleton;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.util.StringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart2D
extends JPanel
implements PropertyChangeListener,
Iterable<ITrace2D>,
Printable {
    public static final String[] AXIX_CONSTANT_NAMES = new String[]{"dummy", "X", "Y", "X,Y"};
    public static final int CHART_POSITION_BOTTOM = 32;
    public static final int CHART_POSITION_LEFT = 4;
    public static final int CHART_POSITION_RIGHT = 8;
    public static final int CHART_POSITION_TOP = 16;
    public static final boolean DEBUG_SCALING = false;
    public static final boolean DEBUG_THREADING = false;
    public static final String PROPERTY_AXIS_X = "Chart2D.PROPERTY_AXIS_X";
    public static final String PROPERTY_AXIS_Y = "Chart2D.PROPERTY_AXIS_Y";
    public static final String PROPERTY_BACKGROUND_COLOR = "Chart2D.PROPERTY_BACKGROUND_COLOR";
    public static final String PROPERTY_FONT = "Chart2D.PROPERTY_FONT";
    public static final String PROPERTY_FOREGROUND_COLOR = "Chart2D.PROPERTY_FOREGROUND_COLOR";
    public static final String PROPERTY_GRID_COLOR = "Chart2D.PROPERTY_GRID_COLOR";
    public static final String PROPERTY_PAINTLABELS = "Chart2D.PROPERTY_PAINTLABELS";
    public static final int X = 1;
    public static final int X_Y = 3;
    public static final int Y = 2;
    private List<IAxis> m_axesXBottom;
    private List<IAxis> m_axesXTop;
    private List<IAxis> m_axesYLeft;
    private List<IAxis> m_axesYRight;
    private IAxisTickPainter m_axisTickPainter;
    private Color m_gridcolor = Color.lightGray;
    protected int m_minPaintLatency = 50;
    private AAxis m_mouseTranslationXAxis;
    private AAxis m_mouseTranslationYAxis;
    private transient PageFormat m_pageFormat;
    private boolean m_paintLabels = true;
    private IPointPainter m_pointHighlighter;
    private Timer m_repainter;
    private boolean m_requestedRepaint;
    private boolean m_synchronizedXStart = false;
    private Chart2D m_synchronizedXStartChart;
    private ToolTipType m_toolTip = ToolTipType.DATAVALUES;
    private int m_xChartEnd;
    private int m_xChartStart;
    private int m_yChartEnd;
    private int m_yChartStart;

    public Chart2D() {
        this.m_axesXBottom = new LinkedList<IAxis>();
        this.m_axesXTop = new LinkedList<IAxis>();
        this.m_axesYLeft = new LinkedList<IAxis>();
        this.m_axesYRight = new LinkedList<IAxis>();
        AxisLinear axisX = new AxisLinear();
        this.setAxisXBottom(axisX);
        axisX.getAxisTitle().setTitle("X");
        AxisLinear axisY = new AxisLinear();
        this.setAxisYLeft(axisY);
        axisY.getAxisTitle().setTitle("Y");
        this.setAxisTickPainter(new AxisTickPainterDefault());
        Font dflt = this.getFont();
        if (dflt != null) {
            this.setFont(new Font(dflt.getFontName(), dflt.getStyle(), 10));
        }
        this.getBackground();
        this.setBackground(Color.white);
        this.setRequestedRepaint(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.setPointHighlighter(new PointPainterDisc(8));
        this.m_repainter = new Timer(this.m_minPaintLatency, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Chart2D chart2D = Chart2D.this;
                synchronized (chart2D) {
                    if (Chart2D.this.isRequestedRepaint()) {
                        Chart2D.this.repaint(Chart2D.this.m_minPaintLatency);
                        Chart2D.this.setRequestedRepaint(false);
                    }
                }
            }
        });
        Timer.setLogTimers(false);
        this.m_repainter.setRepeats(true);
        this.m_repainter.setCoalesce(true);
        this.m_repainter.start();
    }

    public void addAxisXBottom(AAxis axisX) {
        this.ensureUniqueAxis(axisX);
        this.m_axesXBottom.add(axisX);
        axisX.setChart(this, 1, 32);
        this.listenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, null, axisX);
        this.setRequestedRepaint(true);
    }

    public void addAxisXTop(AAxis axisX) {
        this.ensureUniqueAxis(axisX);
        this.m_axesXTop.add(axisX);
        axisX.setChart(this, 1, 16);
        this.listenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, null, axisX);
        this.setRequestedRepaint(true);
    }

    public void addAxisYLeft(AAxis axisY) {
        this.ensureUniqueAxis(axisY);
        this.m_axesYLeft.add(axisY);
        axisY.setChart(this, 2, 4);
        this.listenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, null, axisY);
        this.setRequestedRepaint(true);
    }

    public void addAxisYRight(AAxis axisY) {
        this.ensureUniqueAxis(axisY);
        this.m_axesYRight.add(axisY);
        axisY.setChart(this, 2, 8);
        this.listenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, null, axisY);
        this.setRequestedRepaint(true);
    }

    public final void addTrace(ITrace2D points) {
        IAxis xAxis = this.m_axesXBottom.get(0);
        IAxis yAxis = this.m_axesYLeft.get(0);
        this.addTrace(points, xAxis, yAxis);
    }

    public final void addTrace(ITrace2D points, IAxis xAxis, IAxis yAxis) {
        if (!this.m_axesXBottom.contains(xAxis) && !this.m_axesXTop.contains(xAxis)) {
            throw new IllegalArgumentException("Given x axis (" + xAxis.getAxisTitle().getTitle() + ") has to be added to this chart first (via setAxisX(AAxis) or addAxisXBottom(AAXis) or addAxisXTop(AAXis)).");
        }
        if (!this.m_axesYLeft.contains(yAxis) && !this.m_axesYRight.contains(yAxis)) {
            throw new IllegalArgumentException("Given y axis (" + yAxis.getAxisTitle().getTitle() + ") has to be added to this chart first (via setAxisY(AAxis) or addAxisYLeft(AAXis) or addAxisYRight(AAXis)).");
        }
        xAxis.addTrace(points);
        yAxis.addTrace(points);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip result = super.createToolTip();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            this.m_axesXBottom.clear();
            this.m_axesXBottom = null;
            this.m_axesXTop.clear();
            this.m_axesXTop = null;
            this.m_axesYLeft.clear();
            this.m_axesYLeft = null;
            this.m_axesYRight.clear();
            this.m_axesYRight = null;
            this.m_repainter.stop();
        }
    }

    public IAxis[] findAxesOfTrace(ITrace2D trace) {
        IAxis[] result = new IAxis[2];
        IAxis xAxis = null;
        for (IAxis axis : this.m_axesXBottom) {
            if (!axis.getTraces().contains(trace)) continue;
            xAxis = axis;
            break;
        }
        if (xAxis == null) {
            for (IAxis axis : this.m_axesXTop) {
                if (!axis.getTraces().contains(trace)) continue;
                xAxis = axis;
                break;
            }
        }
        IAxis yAxis = null;
        for (IAxis axis : this.m_axesYLeft) {
            if (!axis.getTraces().contains(trace)) continue;
            yAxis = axis;
            break;
        }
        if (yAxis == null) {
            for (IAxis axis : this.m_axesYRight) {
                if (!axis.getTraces().contains(trace)) continue;
                yAxis = axis;
                break;
            }
        }
        result[0] = xAxis;
        result[1] = yAxis;
        return result;
    }

    public final List<IAxis> getAxes() {
        LinkedList<IAxis> result = new LinkedList<IAxis>();
        result.addAll(this.getAxesXBottom());
        result.addAll(this.getAxesXTop());
        result.addAll(this.getAxesYLeft());
        result.addAll(this.getAxesYRight());
        return result;
    }

    public final List<IAxis> getAxesXBottom() {
        return this.m_axesXBottom;
    }

    public final List<IAxis> getAxesXTop() {
        return this.m_axesXTop;
    }

    public final List<IAxis> getAxesYLeft() {
        return this.m_axesYLeft;
    }

    public final List<IAxis> getAxesYRight() {
        return this.m_axesYRight;
    }

    public IAxisTickPainter getAxisTickPainter() {
        return this.m_axisTickPainter;
    }

    public final IAxis getAxisX() {
        return this.m_axesXBottom.get(0);
    }

    public IAxis getAxisX(ITrace2D trace) {
        IAxis result = null;
        IAxis current2 = null;
        for (IAxis current2 : this.m_axesXBottom) {
            if (!current2.hasTrace(trace)) continue;
            result = current2;
            break;
        }
        if (result == null) {
            for (IAxis current2 : this.m_axesXTop) {
                if (!current2.hasTrace(trace)) continue;
                result = current2;
                break;
            }
        }
        return result;
    }

    public final IAxis getAxisY() {
        return this.m_axesYLeft.get(0);
    }

    public IAxis getAxisY(ITrace2D trace) {
        IAxis result = null;
        IAxis current2 = null;
        for (IAxis current2 : this.m_axesYLeft) {
            if (!current2.hasTrace(trace)) continue;
            result = current2;
            break;
        }
        if (result == null) {
            for (IAxis current2 : this.m_axesYRight) {
                if (!current2.hasTrace(trace)) continue;
                result = current2;
                break;
            }
        }
        return result;
    }

    public final Color getGridColor() {
        return this.m_gridcolor;
    }

    @Override
    public int getHeight() {
        Chart2DActionPrintSingleton printTrigger;
        int result = -1;
        if (this.m_pageFormat != null && (printTrigger = Chart2DActionPrintSingleton.getInstance(this)) != null && printTrigger.isPrintWholePage()) {
            int dpiScreen = Toolkit.getDefaultToolkit().getScreenResolution();
            result = (int)this.m_pageFormat.getImageableHeight() * 72 / dpiScreen;
        }
        if (result == -1) {
            result = super.getHeight();
        }
        return result;
    }

    public synchronized int getMinPaintLatency() {
        return this.m_minPaintLatency;
    }

    public TracePoint2D getNearestPointManhattan(MouseEvent me) {
        double rangeY;
        TracePoint2D result = null;
        int pixelX = me.getX();
        int pixelY = me.getY();
        double scaledX = 0.0;
        double scaledY = 0.0;
        double rangeX = this.getXChartEnd() - this.getXChartStart();
        if (rangeX != 0.0) {
            scaledX = ((double)pixelX - (double)this.getXChartStart()) / rangeX;
        }
        if ((rangeY = (double)(this.getYChartStart() - this.getYChartEnd())) != 0.0) {
            scaledY = 1.0 - ((double)pixelY - (double)this.getYChartEnd()) / rangeY;
        }
        Set<ITrace2D> traces = this.getTraces();
        ITrace2D.ManhattanDistancePoint winner = null;
        for (ITrace2D trace : traces) {
            ITrace2D.ManhattanDistancePoint distanceBean = trace.getNearestPointManhattan(scaledX, scaledY);
            if (winner == null) {
                winner = distanceBean;
                continue;
            }
            if (!(distanceBean.getManhattanDistance() < winner.getManhattanDistance())) continue;
            winner = distanceBean;
        }
        if (winner != null) {
            result = winner.getPoint();
        }
        return result;
    }

    public final IPointPainter getPointHighlighter() {
        return this.m_pointHighlighter;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public final Chart2D getSynchronizedXStartChart() {
        return this.m_synchronizedXStartChart;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String result = this.m_toolTip.getToolTipText(this, event);
        if (result == null) {
            result = super.getToolTipText(event);
        }
        return result;
    }

    public ToolTipType getToolTipType() {
        return this.m_toolTip;
    }

    public final Set<ITrace2D> getTraces() {
        TreeSet<ITrace2D> result = new TreeSet<ITrace2D>();
        for (IAxis currentAxis : this.m_axesXBottom) {
            result.addAll(currentAxis.getTraces());
        }
        for (IAxis currentAxis : this.m_axesXTop) {
            result.addAll(currentAxis.getTraces());
        }
        return result;
    }

    @Override
    public int getWidth() {
        Chart2DActionPrintSingleton printTrigger;
        int result = -1;
        if (this.m_pageFormat != null && (printTrigger = Chart2DActionPrintSingleton.getInstance(this)) != null && printTrigger.isPrintWholePage()) {
            int dpiScreen = Toolkit.getDefaultToolkit().getScreenResolution();
            result = (int)this.m_pageFormat.getImageableWidth() * 72 / dpiScreen;
        }
        if (result == -1) {
            result = super.getWidth();
        }
        return result;
    }

    public final synchronized int getXChartEnd() {
        return this.m_xChartEnd;
    }

    public final synchronized int getXChartStart() {
        return this.m_xChartStart;
    }

    public final synchronized int getYChartEnd() {
        return this.m_yChartEnd;
    }

    public synchronized int getYChartStart() {
        return this.m_yChartStart;
    }

    public final boolean isPaintLabels() {
        return this.m_paintLabels;
    }

    public final boolean isToolTipCoords() {
        return this.m_toolTip == ToolTipType.DATAVALUES;
    }

    @Override
    public final Iterator<ITrace2D> iterator() {
        return this.getTraces().iterator();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result;
        if (pageIndex > 0) {
            result = 1;
        } else {
            this.m_pageFormat = pageFormat;
            this.updateScaling(true);
            this.printAll(graphics);
            result = 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            String property = evt.getPropertyName();
            if (property.equals("IRangePolicy.PROPERTY_RANGE") || property.equals("IRangePolicy.PROPERTY_RANGE") || property.equals("IRangePolicy.PROPERTY_RANGE") || property.equals("ITrace2D.PROPERTY_STROKE") || property.equals("ITrace2D.PROPERTY_COLOR") || property.equals("IAxis.PROPERTY_LABELFORMATTER") || property.equals("ITrace2D.PROPERTY_ADD_REMOVE_TRACE")) {
                // empty if block
            }
            this.setRequestedRepaint(true);
        }
    }

    public Set<ITrace2D> removeAllTraces() {
        Set<ITrace2D> axisTraces;
        TreeSet<ITrace2D> result = new TreeSet<ITrace2D>();
        for (IAxis currentAxis : this.m_axesXBottom) {
            axisTraces = currentAxis.removeAllTraces();
            result.addAll(axisTraces);
        }
        for (IAxis currentAxis : this.m_axesXTop) {
            axisTraces = currentAxis.removeAllTraces();
            result.addAll(axisTraces);
            axisTraces.clear();
        }
        for (IAxis currentAxis : this.m_axesYLeft) {
            axisTraces = currentAxis.removeAllTraces();
            axisTraces.clear();
        }
        for (IAxis currentAxis : this.m_axesYRight) {
            axisTraces = currentAxis.removeAllTraces();
            axisTraces.clear();
        }
        return result;
    }

    public boolean removeAxisXBottom(IAxis axisX) {
        boolean result = this.m_axesXBottom.remove(axisX);
        this.unlistenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, axisX, null);
        this.setRequestedRepaint(true);
        return result;
    }

    public boolean removeAxisXTop(IAxis axisX) {
        boolean result = this.m_axesXTop.remove(axisX);
        this.unlistenToAxis(axisX);
        this.firePropertyChange(PROPERTY_AXIS_X, axisX, null);
        this.setRequestedRepaint(true);
        return result;
    }

    public boolean removeAxisYLeft(IAxis axisY) {
        boolean result = this.m_axesYLeft.remove(axisY);
        this.unlistenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, axisY, null);
        this.setRequestedRepaint(true);
        return result;
    }

    public boolean removeAxisYRight(IAxis axisY) {
        boolean result = this.m_axesYRight.remove(axisY);
        this.unlistenToAxis(axisY);
        this.firePropertyChange(PROPERTY_AXIS_Y, axisY, null);
        this.setRequestedRepaint(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTrace(ITrace2D points) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            IAxis currentAxis2;
            Iterator<IAxis> it = this.m_axesXBottom.iterator();
            boolean success = true;
            while (it.hasNext()) {
                currentAxis2 = it.next();
                success = currentAxis2.removeTrace(points);
                if (!success) continue;
                success = false;
                break;
            }
            if (success) {
                for (IAxis currentAxis2 : this.m_axesXTop) {
                    success = currentAxis2.removeTrace(points);
                    if (!success) continue;
                    success = false;
                    break;
                }
            }
            success = true;
            for (IAxis currentAxis2 : this.m_axesYLeft) {
                success = currentAxis2.removeTrace(points);
                if (!success) continue;
                success = false;
                break;
            }
            if (success) {
                it = this.m_axesYRight.iterator();
                while (it.hasNext() && !(success = (currentAxis2 = it.next()).removeTrace(points))) {
                }
            }
            if (success) {
                this.setRequestedRepaint(true);
            }
        }
    }

    @Override
    @Deprecated
    public void repaint() {
        super.repaint();
    }

    @Override
    @Deprecated
    public void repaint(int x, int y, int width, int height) {
        super.repaint(x, y, width, height);
    }

    @Override
    @Deprecated
    public void repaint(long tm) {
        super.repaint(tm);
    }

    @Override
    @Deprecated
    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
    }

    @Override
    @Deprecated
    public void repaint(Rectangle r) {
        super.repaint(r);
    }

    public void resetPrintMode() {
        this.m_pageFormat = null;
        this.setRequestedRepaint(true);
    }

    public synchronized void setAxisTickPainter(IAxisTickPainter tickPainter) {
        this.m_axisTickPainter = tickPainter;
    }

    @Deprecated
    public List<IAxis> setAxisX(AAxis axisX) {
        return this.setAxisXBottom(axisX);
    }

    public List<IAxis> setAxisXBottom(AAxis axisX) {
        LinkedList<IAxis> result = new LinkedList<IAxis>(this.m_axesXBottom);
        IAxis old2 = null;
        this.addAxisXBottom(axisX);
        for (IAxis old2 : result) {
            Set<ITrace2D> traces = old2.getTraces();
            for (ITrace2D trace : traces) {
                axisX.addTrace(trace);
            }
            this.removeAxisXBottom(old2);
        }
        this.m_mouseTranslationXAxis = axisX;
        this.setRequestedRepaint(true);
        return result;
    }

    public List<IAxis> setAxisXTop(AAxis axisX) {
        LinkedList<IAxis> result = new LinkedList<IAxis>(this.m_axesXTop);
        IAxis old2 = null;
        this.addAxisXTop(axisX);
        for (IAxis old2 : result) {
            this.removeAxisXTop(old2);
            Set<ITrace2D> traces = old2.getTraces();
            for (ITrace2D trace : traces) {
                axisX.addTrace(trace);
            }
        }
        this.m_mouseTranslationXAxis = axisX;
        this.setRequestedRepaint(true);
        return result;
    }

    @Deprecated
    public List<IAxis> setAxisY(AAxis axisY) {
        return this.setAxisYLeft(axisY);
    }

    public List<IAxis> setAxisYLeft(AAxis axisY) {
        LinkedList<IAxis> result = new LinkedList<IAxis>(this.m_axesYLeft);
        IAxis old2 = null;
        this.addAxisYLeft(axisY);
        for (IAxis old2 : result) {
            this.removeAxisYLeft(old2);
            Set<ITrace2D> traces = old2.getTraces();
            for (ITrace2D trace : traces) {
                axisY.addTrace(trace);
            }
        }
        this.m_mouseTranslationYAxis = axisY;
        this.setRequestedRepaint(true);
        return result;
    }

    public List<IAxis> setAxisYRight(AAxis axisY) {
        LinkedList<IAxis> result = new LinkedList<IAxis>(this.m_axesYRight);
        IAxis old2 = null;
        this.addAxisYRight(axisY);
        for (IAxis old2 : result) {
            this.removeAxisYRight(old2);
            Set<ITrace2D> traces = old2.getTraces();
            for (ITrace2D trace : traces) {
                axisY.addTrace(trace);
            }
        }
        this.m_mouseTranslationYAxis = axisY;
        this.setRequestedRepaint(true);
        return result;
    }

    @Override
    public void setBackground(Color bg) {
        Color old = this.getBackground();
        super.setBackground(bg);
        this.firePropertyChange(PROPERTY_BACKGROUND_COLOR, old, bg);
    }

    @Override
    public void setForeground(Color fg) {
        Color old = this.getForeground();
        super.setForeground(fg);
        this.firePropertyChange(PROPERTY_FOREGROUND_COLOR, old, fg);
    }

    public final void setGridColor(Color gridclr) {
        if (gridclr != null) {
            Color old = this.m_gridcolor;
            this.m_gridcolor = gridclr;
            if (!old.equals(this.m_gridcolor)) {
                this.firePropertyChange(PROPERTY_GRID_COLOR, old, this.m_gridcolor);
            }
            this.setRequestedRepaint(true);
        }
    }

    public synchronized void setMinPaintLatency(int minPaintLatency) {
        this.m_minPaintLatency = minPaintLatency;
        this.m_repainter.setDelay(this.m_minPaintLatency);
    }

    public void setPaintLabels(boolean paintLabels) {
        boolean change = this.m_paintLabels != paintLabels;
        this.m_paintLabels = paintLabels;
        if (change) {
            this.firePropertyChange(PROPERTY_PAINTLABELS, new Boolean(!paintLabels), new Boolean(paintLabels));
            this.setRequestedRepaint(true);
        }
    }

    public final void setPointHighlighter(IPointPainter pointHighlighter) {
        this.m_pointHighlighter = pointHighlighter;
    }

    public final synchronized void setRequestedRepaint(boolean requestedRepaint) {
        this.m_requestedRepaint = requestedRepaint;
    }

    public void setSynchronizedXStartChart(Chart2D synchronizedXStartChart) {
        this.m_synchronizedXStartChart = synchronizedXStartChart;
        this.m_synchronizedXStart = false;
        synchronizedXStartChart.m_synchronizedXStart = true;
    }

    @Deprecated
    public final void setToolTipCoords(boolean toolTipCoords) {
        this.setToolTipType(ToolTipType.DATAVALUES);
    }

    public final void setToolTipType(ToolTipType toolTipType) {
        if (toolTipType == ToolTipType.NONE) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("turnOn");
        }
        this.m_toolTip = toolTipType;
    }

    public BufferedImage snapShot() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 && height <= 0) {
            width = 600;
            height = 400;
        }
        return this.snapShot(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage snapShot(int width, int height) {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            Dimension dsave = new Dimension(this.getWidth(), this.getHeight());
            this.setSize(new Dimension(width, height));
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics2D g2d = (Graphics2D)img.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(g2d);
            this.setSize(dsave);
            return img;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Chart2D chart2D = this;
        synchronized (chart2D) {
            return super.toString();
        }
    }

    public TracePoint2D translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        if (mouseEvent.getSource() != this) {
            throw new IllegalArgumentException("The given mouse event does not belong to this chart but to: " + mouseEvent.getSource());
        }
        TracePoint2D result = null;
        double valueX = this.m_mouseTranslationXAxis.translateMousePosition(mouseEvent);
        double valueY = this.m_mouseTranslationYAxis.translateMousePosition(mouseEvent);
        result = new TracePoint2D(valueX, valueY);
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    protected synchronized boolean isRequestedRepaint() {
        return this.m_requestedRepaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_pageFormat != null) {
            Graphics2D g2d = (Graphics2D)g;
            double startX = this.m_pageFormat.getImageableX();
            double startY = this.m_pageFormat.getImageableY();
            g2d.translate(startX, startY);
        }
        this.updateScaling(false);
        this.negociateXChart(g);
        int labelHeight = this.paintTraceLabels(g);
        this.m_yChartStart = this.calculateYChartStart(g, labelHeight);
        this.m_yChartEnd = this.calculateYChartEnd(g);
        int rangex = this.m_xChartEnd - this.m_xChartStart;
        int rangey = this.m_yChartStart - this.m_yChartEnd;
        this.paintCoordinateSystem(g);
        int tmpx = 0;
        int tmpy = 0;
        TracePoint2D oldpoint = null;
        TracePoint2D newpoint = null;
        TracePoint2D tmppt = null;
        Iterator<ITrace2D> traceIt = this.getTraces().iterator();
        Graphics2D g2d = null;
        Stroke backupStroke = null;
        boolean strokeSupport = g instanceof Graphics2D;
        if (strokeSupport) {
            g2d = (Graphics2D)g;
            backupStroke = g2d.getStroke();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int count = 0;
        while (traceIt.hasNext()) {
            oldpoint = null;
            newpoint = null;
            ++count;
            ITrace2D tmpdata = traceIt.next();
            if (!tmpdata.isVisible()) continue;
            boolean hasErrorBars = tmpdata.getHasErrorBars();
            if (strokeSupport) {
                g2d.setStroke(tmpdata.getStroke());
            }
            g.setColor(tmpdata.getColor());
            ITrace2D iTrace2D = tmpdata;
            synchronized (iTrace2D) {
                Set<ITracePainter> tracePainters = tmpdata.getTracePainters();
                Iterator<ITracePainter> itTracePainters = tracePainters.iterator();
                ITracePainter tracePainter2 = null;
                while (itTracePainters.hasNext()) {
                    tracePainter2 = itTracePainters.next();
                    tracePainter2.startPaintIteration(g);
                }
                IErrorBarPolicy errorBarPolicy2 = null;
                Set<IErrorBarPolicy> errorBarPolicies = tmpdata.getErrorBarPolicies();
                for (IErrorBarPolicy errorBarPolicy2 : errorBarPolicies) {
                    errorBarPolicy2.startPaintIteration(g);
                }
                Iterator<TracePoint2D> pointIt = tmpdata.iterator();
                boolean newpointVisible = false;
                boolean oldpointVisible = false;
                while (pointIt.hasNext()) {
                    oldpoint = newpoint;
                    int oldtmpx = tmpx;
                    int oldtmpy = tmpy;
                    newpoint = pointIt.next();
                    newpointVisible = this.isVisible(newpoint);
                    oldpointVisible = this.isVisible(oldpoint);
                    if (!newpointVisible && !oldpointVisible) {
                        tmppt = (TracePoint2D)newpoint.clone();
                        int tmptmpx = tmpx;
                        int tmptmpy = tmpy;
                        if (!this.isEqualInterPolationBound(oldpoint = this.interpolateVisible(oldpoint, newpoint), newpoint = this.interpolateVisible(newpoint, oldpoint)) && this.isVisible(oldpoint) && this.isVisible(newpoint)) {
                            tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                            tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                            oldtmpx = this.m_xChartStart + (int)Math.round(oldpoint.getScaledX() * (double)rangex);
                            oldtmpy = this.m_yChartStart - (int)Math.round(oldpoint.getScaledY() * (double)rangey);
                            this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, true, tmpdata, g, newpoint, hasErrorBars);
                        }
                        newpoint = tmppt;
                        tmpx = tmptmpx;
                        tmpy = tmptmpy;
                        continue;
                    }
                    if (newpointVisible && !oldpointVisible) {
                        oldpoint = this.interpolateVisible(oldpoint, newpoint);
                        tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                        tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                        oldtmpx = this.m_xChartStart + (int)Math.round(oldpoint.getScaledX() * (double)rangex);
                        oldtmpy = this.m_yChartStart - (int)Math.round(oldpoint.getScaledY() * (double)rangey);
                        this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, true, tmpdata, g, newpoint, hasErrorBars);
                        continue;
                    }
                    if (!newpointVisible && oldpointVisible) {
                        tmppt = (TracePoint2D)newpoint.clone();
                        newpoint = this.interpolateVisible(newpoint, oldpoint);
                        tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                        tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                        this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, true, tmpdata, g, newpoint, hasErrorBars);
                        newpoint = tmppt;
                        continue;
                    }
                    tmpx = this.m_xChartStart + (int)Math.round(newpoint.getScaledX() * (double)rangex);
                    tmpy = this.m_yChartStart - (int)Math.round(newpoint.getScaledY() * (double)rangey);
                    this.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, false, tmpdata, g, newpoint, hasErrorBars);
                }
                for (ITracePainter tracePainter2 : tmpdata.getTracePainters()) {
                    tracePainter2.endPaintIteration(g);
                }
                for (IErrorBarPolicy errorBarPolicy2 : tmpdata.getErrorBarPolicies()) {
                    errorBarPolicy2.endPaintIteration(g);
                }
            }
        }
        if (strokeSupport) {
            g2d.setStroke(backupStroke);
        }
    }

    private int calculateXChartEnd(Graphics g2d) {
        int result = (int)this.getSize().getWidth();
        int axisWidth = 0;
        if (this.m_axesYRight.size() > 0) {
            ListIterator<IAxis> it = this.m_axesYRight.listIterator(this.m_axesYRight.size());
            while (it.hasPrevious()) {
                IAxis currentAxis = it.previous();
                axisWidth = currentAxis.getWidth(g2d);
                currentAxis.setPixelXRight(result);
                currentAxis.setPixelXLeft(result -= axisWidth);
            }
        } else {
            int tmp;
            Iterator<IAxis> it = this.m_axesXBottom.iterator();
            int xAxesMaxLabelWidth = 0;
            while (it.hasNext()) {
                IAxis currentAxis = it.next();
                tmp = currentAxis.getWidth(g2d);
                if (tmp <= xAxesMaxLabelWidth) continue;
                xAxesMaxLabelWidth = tmp;
            }
            for (IAxis currentAxis : this.m_axesXTop) {
                tmp = currentAxis.getWidth(g2d);
                if (tmp <= xAxesMaxLabelWidth) continue;
                xAxesMaxLabelWidth = tmp;
            }
            result -= xAxesMaxLabelWidth;
        }
        return result;
    }

    private int calculateXChartStart(Graphics g2d) {
        int result = 0;
        ListIterator<IAxis> it = this.m_axesYLeft.listIterator(this.m_axesYLeft.size());
        while (it.hasPrevious()) {
            IAxis currentAxis = it.previous();
            currentAxis.setPixelXLeft(result);
            currentAxis.setPixelXRight(result += currentAxis.getWidth(g2d));
        }
        return result;
    }

    private int calculateYChartEnd(Graphics g2d) {
        int tmp;
        int result = 0;
        int maxAxisYHeight = 0;
        int axesXTopHeight = 0;
        for (IAxis currentAxis : this.m_axesYLeft) {
            tmp = currentAxis.getHeight(g2d);
            if (tmp <= maxAxisYHeight) continue;
            maxAxisYHeight = tmp;
        }
        for (IAxis currentAxis : this.m_axesYRight) {
            tmp = currentAxis.getHeight(g2d);
            if (tmp <= maxAxisYHeight) continue;
            maxAxisYHeight = tmp;
        }
        ListIterator<IAxis> listIt = this.m_axesXTop.listIterator(this.m_axesXTop.size());
        int axisHeight = 0;
        while (listIt.hasPrevious()) {
            IAxis currentAxis;
            currentAxis = listIt.previous();
            currentAxis.setPixelYTop(axesXTopHeight);
            axisHeight = currentAxis.getHeight(g2d);
            currentAxis.setPixelYBottom(axesXTopHeight += axisHeight);
        }
        result = Math.max(maxAxisYHeight, axesXTopHeight);
        return result;
    }

    private int calculateYChartStart(Graphics g2d, int labelHeight) {
        int result = (int)this.getSize().getHeight();
        result -= labelHeight;
        int axesXBottomHeight = 0;
        for (IAxis currentAxis : this.m_axesXBottom) {
            currentAxis.setPixelYBottom(result);
            currentAxis.setPixelYTop(result -= currentAxis.getHeight(g2d));
        }
        return result -= axesXBottomHeight;
    }

    private void ensureUniqueAxis(IAxis axisToAdd) {
        if (this.m_axesXBottom.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as bottom x axis!");
        }
        if (this.m_axesXTop.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as top x axis!");
        }
        if (this.m_axesYLeft.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as left y axis!");
        }
        if (this.m_axesYRight.contains(axisToAdd)) {
            throw new IllegalArgumentException("Given axis (" + axisToAdd.getAxisTitle().getTitle() + " is already configured as right y axis!");
        }
    }

    private TracePoint2D interpolateVisible(TracePoint2D invisible, TracePoint2D visible) {
        TracePoint2D result;
        if (invisible == null) {
            result = visible;
        } else {
            double xInterpolate = Double.NaN;
            double yInterpolate = Double.NaN;
            boolean interpolated = false;
            boolean interpolatedWrong = false;
            if (invisible.getScaledX() > 1.0) {
                xInterpolate = 1.0;
                yInterpolate = (visible.getScaledY() - invisible.getScaledY()) / (visible.getScaledX() - invisible.getScaledX()) * (1.0 - invisible.getScaledX()) + invisible.getScaledY();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(yInterpolate) || yInterpolate < 0.0 || yInterpolate > 1.0;
            }
            if (invisible.getScaledX() < 0.0 && (!interpolated || interpolatedWrong)) {
                xInterpolate = 0.0;
                yInterpolate = (visible.getScaledY() - invisible.getScaledY()) / (visible.getScaledX() - invisible.getScaledX()) * -invisible.getScaledX() + invisible.getScaledY();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(yInterpolate) || yInterpolate < 0.0 || yInterpolate > 1.0;
            }
            if (invisible.getScaledY() > 1.0 && (!interpolated || interpolatedWrong)) {
                yInterpolate = 1.0;
                xInterpolate = (1.0 - invisible.getScaledY()) * (visible.getScaledX() - invisible.getScaledX()) / (visible.getScaledY() - invisible.getScaledY()) + invisible.getScaledX();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(xInterpolate) || xInterpolate < 0.0 || xInterpolate > 1.0;
            }
            if (invisible.getScaledY() < 0.0 && (!interpolated || interpolatedWrong)) {
                yInterpolate = 0.0;
                xInterpolate = -invisible.getScaledY() * (visible.getScaledX() - invisible.getScaledX()) / (visible.getScaledY() - invisible.getScaledY()) + invisible.getScaledX();
                interpolated = true;
                boolean bl = interpolatedWrong = Double.isNaN(xInterpolate) || xInterpolate < 0.0 || xInterpolate > 1.0;
            }
            if (interpolatedWrong) {
                result = visible;
            } else {
                result = new TracePoint2D(0.0, 0.0);
                result.setHighlight(invisible.isHighlight());
                result.setScaledX(xInterpolate);
                result.setScaledY(yInterpolate);
            }
        }
        return result;
    }

    private boolean isEqualInterPolationBound(TracePoint2D oldpoint, TracePoint2D newpoint) {
        return oldpoint.getScaledX() == newpoint.getScaledX() || oldpoint.getScaledY() == newpoint.getScaledY();
    }

    private boolean isVisible(TracePoint2D point) {
        boolean result = point == null ? false : !(point.getScaledX() > 1.0 || point.getScaledX() < 0.0 || point.getScaledY() > 1.0 || point.getScaledY() < 0.0);
        return result;
    }

    private void listenToAxis(IAxis iAxis) {
        iAxis.addPropertyChangeListener("ITrace2D.PROPERTY_ADD_REMOVE_TRACE", this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_PAINTGRID", this);
        iAxis.addPropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
    }

    private void negociateXChart(Graphics g2d) {
        if (this.m_synchronizedXStartChart != null) {
            this.m_xChartStart = Math.max(this.calculateXChartStart(g2d), this.m_synchronizedXStartChart.calculateXChartStart(g2d));
            this.m_xChartEnd = Math.max(this.calculateXChartEnd(g2d), this.m_synchronizedXStartChart.calculateXChartEnd(g2d));
            this.m_synchronizedXStartChart.m_xChartStart = this.m_xChartStart;
            this.m_synchronizedXStartChart.m_xChartEnd = this.m_xChartEnd;
        } else if (!this.m_synchronizedXStart) {
            this.m_xChartStart = this.calculateXChartStart(g2d);
            this.m_xChartEnd = this.calculateXChartEnd(g2d);
        }
    }

    private void paintCoordinateSystem(Graphics g2d) {
        g2d.setColor(this.getForeground());
        for (IAxis currentAxis : this.m_axesXBottom) {
            currentAxis.paint(g2d);
        }
        for (IAxis currentAxis : this.m_axesXTop) {
            currentAxis.paint(g2d);
        }
        for (IAxis currentAxis : this.m_axesYLeft) {
            currentAxis.paint(g2d);
        }
        for (IAxis currentAxis : this.m_axesYRight) {
            currentAxis.paint(g2d);
        }
    }

    private void paintErrorBars(ITrace2D trace, int oldtmpx, int oldtmpy, int tmpx, int tmpy, Graphics g2d, boolean discontinue, TracePoint2D original) {
        for (IErrorBarPolicy errorBarPolicy : trace.getErrorBarPolicies()) {
            errorBarPolicy.paintPoint(oldtmpx, oldtmpy, tmpx, tmpy, g2d, original);
            if (!discontinue) continue;
            errorBarPolicy.discontinue(g2d);
        }
    }

    private final void paintPoint(int xPxOld, int yPxOld, int xPxNew, int yPxNew, boolean discontinue, ITrace2D trace, Graphics g2d, TracePoint2D original, boolean errorBarSupport) {
        for (ITracePainter tracePainter : trace.getTracePainters()) {
            tracePainter.paintPoint(xPxOld, yPxOld, xPxNew, yPxNew, g2d, original);
            if (original.isHighlight()) {
                this.getPointHighlighter().paintPoint(xPxNew, yPxNew, xPxNew, yPxNew, g2d, original);
                original.setHighlight(false);
            }
            if (!discontinue) continue;
            tracePainter.discontinue(g2d);
        }
        if (errorBarSupport) {
            this.paintErrorBars(trace, xPxOld, yPxOld, xPxNew, yPxNew, g2d, discontinue, original);
        }
    }

    private int paintTraceLabels(Graphics g2d) {
        int labelheight = 0;
        Dimension d = this.getSize();
        if (this.m_paintLabels) {
            int remwidth;
            Iterator<ITrace2D> traceIt = this.getTraces().iterator();
            int xtmpos = this.m_xChartStart;
            int ytmpos = (int)d.getHeight() - 2;
            int allwidth = remwidth = (int)d.getWidth() - this.m_xChartStart;
            int lblwidth = 0;
            boolean crlfdone = false;
            FontMetrics fontdim = g2d.getFontMetrics();
            int fontheight = fontdim.getHeight();
            if (traceIt.hasNext()) {
                labelheight += fontheight;
            }
            while (traceIt.hasNext()) {
                String tmplabel;
                ITrace2D trace = traceIt.next();
                if (!trace.isVisible() || StringUtil.isEmpty(tmplabel = trace.getLabel())) continue;
                lblwidth = fontdim.stringWidth(tmplabel) + 10;
                if (lblwidth > remwidth) {
                    if (lblwidth <= allwidth || !crlfdone) {
                        ytmpos -= fontheight;
                        xtmpos = this.m_xChartStart;
                        labelheight += fontheight;
                        crlfdone = true;
                        remwidth = (int)d.getWidth() - this.m_xChartStart;
                    } else {
                        crlfdone = false;
                    }
                }
                remwidth -= lblwidth;
                g2d.setColor(trace.getColor());
                g2d.drawString(tmplabel, xtmpos, ytmpos);
                xtmpos += lblwidth;
            }
        }
        return labelheight;
    }

    private void unlistenToAxis(IAxis iAxis) {
        iAxis.removePropertyChangeListener("ITrace2D.PROPERTY_ADD_REMOVE_TRACE", this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_PAINTGRID", this);
        iAxis.removePropertyChangeListener("IAxis.PROPERTY_RANGEPOLICY", this);
    }

    private synchronized void updateScaling(boolean force) {
        boolean changed;
        for (IAxis currentAxis : this.m_axesXBottom) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
        for (IAxis currentAxis : this.m_axesXTop) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
        for (IAxis currentAxis : this.m_axesYLeft) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
        for (IAxis currentAxis : this.m_axesYRight) {
            changed = force;
            changed = changed || currentAxis.isDirtyScaling();
            if (!changed) continue;
            currentAxis.initPaintIteration();
            currentAxis.scale();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolTipType {
        DATAVALUES{

            public String getToolTipText(Chart2D chart, MouseEvent me) {
                TracePoint2D tracePoint = chart.translateMousePosition(me);
                StringBuffer buffer = new StringBuffer("X: ");
                buffer.append(chart.getAxisX().getFormatter().format(tracePoint.getX())).append(" ");
                buffer.append("Y: ");
                buffer.append(chart.getAxisY().getFormatter().format(tracePoint.getY()));
                String result = buffer.toString();
                return result;
            }
        }
        ,
        NONE,
        PIXEL{

            public String getToolTipText(Chart2D chart, MouseEvent me) {
                return "pixel, not implemented yet";
            }
        }
        ,
        VALUE_SNAP_TO_TRACEPOINTS{

            public String getToolTipText(Chart2D chart, MouseEvent me) {
                TracePoint2D point = chart.getNearestPointManhattan(me);
                ITrace2D trace = point.getListener();
                IAxis xAxis = chart.getAxisX(trace);
                IAxis yAxis = chart.getAxisY(trace);
                point.setHighlight(true);
                chart.setRequestedRepaint(true);
                StringBuffer buffer = new StringBuffer("X: ");
                buffer.append(xAxis.getFormatter().format(point.getX())).append(" ");
                buffer.append("Y: ");
                buffer.append(yAxis.getFormatter().format(point.getY()));
                String result = buffer.toString();
                return result;
            }
        };


        public String getToolTipText(Chart2D chart, MouseEvent me) {
            return null;
        }
    }
}

