/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public final class MultiTracing
extends JFrame {
    protected Chart2D m_chart1 = new Chart2D();

    public static void main(String[] args) {
        int i;
        double[][] data = new double[6][200];
        Random rand = new Random();
        data[0][0] = rand.nextDouble() * 5.0;
        for (int i2 = 1; i2 < data[0].length; ++i2) {
            data[0][i2] = rand.nextDouble() < 0.5 ? data[0][i2 - 1] + rand.nextDouble() * 5.0 : data[0][i2 - 1] - rand.nextDouble() * 5.0;
        }
        for (i = 0; i < data[0].length; ++i) {
            double tmp;
            data[1][i] = tmp = Math.pow(Math.E, (double)i / 40.0) + (Math.random() < 0.5 ? data[0][i] : -data[0][i]);
        }
        for (i = 0; i < data[0].length; ++i) {
            data[2][i] = Math.pow(Math.cos((double)i / 10.0) * 5.0, 2.0);
        }
        data[3][0] = data[0][0];
        double tmp = 0.0;
        for (i = 1; i < data[0].length; ++i) {
            for (int j = Math.max(0, i - 10); j <= i; ++j) {
                tmp += data[0][j];
            }
            data[3][i] = tmp / ((double)i + 1.0);
            tmp = 0.0;
        }
        for (i = 0; i < data[0].length; ++i) {
            data[4][i] = data[1][i] + data[2][i] * (0.1 * -data[0][i]);
        }
        for (i = 0; i < data[0].length; ++i) {
            data[5][i] = data[0][i] + data[2][i];
        }
        MultiTracing wnd = new MultiTracing();
        wnd.setLocation(100, 300);
        wnd.setSize(800, 300);
        wnd.setResizable(true);
        wnd.setVisible(true);
        Range myXRange = new Range(0.0, 300.0);
        wnd.setForceXRange(myXRange);
        Trace2DSimple trace = new Trace2DSimple();
        trace.setColor(Color.red);
        new AddPaintRemoveThread(wnd.m_chart1, trace, data[0], 5L).start();
        trace = new Trace2DSimple();
        trace.setColor(Color.green);
        new AddPaintRemoveThread(wnd.m_chart1, trace, data[1], 7L).start();
        trace = new Trace2DSimple();
        trace.setColor(Color.blue);
        new AddPaintRemoveThread(wnd.m_chart1, trace, data[2], 10L).start();
        trace = new Trace2DSimple();
        trace.setColor(Color.cyan);
        new AddPaintRemoveThread(wnd.m_chart1, trace, data[3], 12L).start();
        trace = new Trace2DSimple();
        trace.setColor(Color.black);
        new AddPaintRemoveThread(wnd.m_chart1, trace, data[4], 15L).start();
        trace = new Trace2DSimple();
        trace.setColor(Color.white);
        new AddPaintRemoveThread(wnd.m_chart1, trace, data[5], 17L).start();
    }

    public MultiTracing() {
        super("MultiTracing");
        this.m_chart1.getAxisX().getAxisTitle().setTitle(null);
        this.m_chart1.getAxisY().getAxisTitle().setTitle(null);
        this.m_chart1.getAxisX().setPaintGrid(true);
        this.m_chart1.getAxisY().setPaintGrid(true);
        this.m_chart1.setBackground(Color.lightGray);
        this.m_chart1.setGridColor(new Color(221, 221, 221));
        this.m_chart1.getAxisY().setRangePolicy(new RangePolicyFixedViewport(new Range(-180.0, 200.0)));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ChartPanel panel = new ChartPanel(this.m_chart1);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "TitledBorder", 1, 2));
        contentPane.add((Component)panel, "Center");
    }

    public void setForceXRange(Range forceXRange) {
        System.out.println("forceXRange:" + forceXRange.toString());
        this.m_chart1.getAxisX().setRangePolicy(new RangePolicyMinimumViewport(forceXRange));
    }

    public void setForceYRange(Range forceYRange) {
        this.m_chart1.getAxisY().setRangePolicy(new RangePolicyMinimumViewport(forceYRange));
    }

    static final class AddPaintRemoveThread
    extends Thread {
        private double[] m_data;
        private Chart2D m_innnerChart;
        private long m_sleep;
        private ITrace2D m_trace;

        public AddPaintRemoveThread(Chart2D chart, ITrace2D trace, double[] data, long sleep) {
            this.m_innnerChart = chart;
            this.m_trace = trace;
            this.m_trace.setName(this.getName());
            System.out.println(((BasicStroke)this.m_trace.getStroke()).getLineWidth() + " " + ((BasicStroke)this.m_trace.getStroke()).getEndCap() + " " + ((BasicStroke)this.m_trace.getStroke()).getLineJoin());
            this.m_data = data;
            this.m_sleep = sleep;
        }

        public void run() {
            while (true) {
                System.out.println(this.getName() + "(" + Thread.currentThread().getName() + ") adding trace.");
                this.m_innnerChart.addTrace(this.m_trace);
                for (int i = 0; i < this.m_data.length; ++i) {
                    this.m_trace.addPoint(i, this.m_data[i]);
                    try {
                        Thread.sleep(this.m_sleep);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                }
                try {
                    Thread.sleep((long)(Math.random() * (double)this.m_sleep));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                System.out.println(this.getName() + "(" + Thread.currentThread().getName() + ") removing trace.");
                this.m_innnerChart.removeTrace(this.m_trace);
                this.m_trace.removeAllPoints();
                try {
                    Thread.sleep((long)(Math.random() * (double)this.m_sleep));
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

