/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.events.Chart2DActionSaveImageSingleton;
import info.monitorenter.gui.chart.io.ADataCollector;
import info.monitorenter.gui.chart.io.RandomDataCollectorTimeStamped;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Showcase
extends JApplet {
    protected Chart2D m_chart;
    private transient ADataCollector m_collector;
    private Trace2DLtd m_trace;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Showcase");
        Showcase showcase = new Showcase();
        showcase.init();
        frame.getContentPane().add(showcase);
        frame.setSize(400, 600);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public synchronized void clearTrace() {
        this.getTrace().removeAllPoints();
    }

    public Chart2D getChart() {
        return this.m_chart;
    }

    public ADataCollector getCollector() {
        return this.m_collector;
    }

    public Trace2DLtd getTrace() {
        return this.m_trace;
    }

    public void init() {
        super.init();
        Chart2D chart = new Chart2D();
        chart.getAxisX().setFormatter(new LabelFormatterDate((SimpleDateFormat)DateFormat.getTimeInstance()));
        this.setChart(chart);
        this.setSize(new Dimension(400, 500));
        this.m_chart.getAxisX().setPaintGrid(true);
        this.m_chart.getAxisY().setPaintGrid(true);
        chart.getAxisY().setRangePolicy(new RangePolicyMinimumViewport(new Range(0.0, 100.0)));
        chart.setGridColor(Color.LIGHT_GRAY);
        this.setTrace(new Trace2DLtd(100));
        this.getTrace().setName("random");
        this.getTrace().setPhysicalUnits("Milliseconds", "random value");
        this.getTrace().setColor(Color.RED);
        chart.addTrace(this.getTrace());
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        LayoutFactory factory = LayoutFactory.getInstance();
        this.setJMenuBar(factory.createMenuBar(chart, false));
        ChartPanel chartpanel = new ChartPanel(chart);
        content.add(chartpanel);
        content.addPropertyChangeListener(chartpanel);
        this.setCollector(new RandomDataCollectorTimeStamped((ITrace2D)this.getTrace(), 50));
        content.add(new ControlPanel());
    }

    public void setChart(Chart2D chart2D) {
        if (this.m_chart == null) {
            this.m_chart = chart2D;
        }
    }

    private void setCollector(ADataCollector collector) {
        this.m_collector = collector;
    }

    public void setTrace(Trace2DLtd trace) {
        if (this.m_trace == null) {
            this.m_trace = trace;
        }
    }

    public synchronized void startData() {
        if (!this.getCollector().isRunning()) {
            this.getCollector().start();
        }
    }

    public synchronized void stopData() {
        if (this.getCollector().isRunning()) {
            this.getCollector().stop();
        }
    }

    final class ControlPanel
    extends JPanel {
        private JSlider m_amountPointsSlider;
        private JButton m_clear;
        private JComboBox m_colorChooser;
        private JSlider m_latencyTimeSlider;
        private JButton m_snapshot;
        private JButton m_startStop;

        protected ControlPanel() {
            this.setBackground(Color.WHITE);
            this.createAmountPointSlider();
            this.createLatencySlider();
            this.createStartStopButton();
            this.createSnapShotButton();
            this.createClearButton();
            this.createColorChooserButton();
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.m_amountPointsSlider);
            this.add(this.m_latencyTimeSlider);
            JPanel stretch = new JPanel();
            stretch.setBackground(Color.WHITE);
            stretch.setLayout(new BoxLayout(stretch, 0));
            stretch.add(Box.createHorizontalGlue());
            stretch.add(this.m_startStop);
            stretch.add(Box.createHorizontalGlue());
            stretch.add(this.m_clear);
            if (this.m_snapshot != null) {
                stretch.add(Box.createHorizontalGlue());
                stretch.add(this.m_snapshot);
            }
            stretch.add(Box.createHorizontalGlue());
            stretch.add(this.m_colorChooser);
            stretch.add(Box.createHorizontalGlue());
            this.add(stretch);
        }

        private void createAmountPointSlider() {
            this.m_amountPointsSlider = new JSlider(10, 1800);
            this.m_amountPointsSlider.setBackground(Color.WHITE);
            int maxPoints = Showcase.this.getTrace().getMaxSize();
            this.m_amountPointsSlider.setValue(maxPoints);
            this.m_amountPointsSlider.setMajorTickSpacing(100);
            this.m_amountPointsSlider.setMinorTickSpacing(50);
            this.m_amountPointsSlider.setSnapToTicks(true);
            this.m_amountPointsSlider.setPaintLabels(true);
            this.m_amountPointsSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Amount of points.", 1, 3));
            this.m_amountPointsSlider.setPaintTicks(true);
            this.m_amountPointsSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        Showcase.this.getTrace().setMaxSize(value);
                    }
                }
            });
        }

        private void createClearButton() {
            this.m_clear = new JButton("clear");
            this.m_clear.setBackground(Color.WHITE);
            this.m_clear.setBackground(Color.WHITE);
            this.m_clear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Showcase.this.clearTrace();
                }
            });
        }

        private void createColorChooserButton() {
            this.m_colorChooser = new JComboBox();
            this.m_colorChooser.setBackground(Color.WHITE);
            final class ColorItem
            extends Color {
                private String m_name;

                public ColorItem(Color c, String name) {
                    super(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
                    this.m_name = name;
                }

                public String toString() {
                    return this.m_name;
                }
            }
            this.m_colorChooser.addItem(new ColorItem(Color.BLACK, "black"));
            this.m_colorChooser.addItem(new ColorItem(Color.BLUE, "blue"));
            this.m_colorChooser.addItem(new ColorItem(Color.CYAN, "cyan"));
            this.m_colorChooser.addItem(new ColorItem(Color.DARK_GRAY, "darg gray"));
            this.m_colorChooser.addItem(new ColorItem(Color.GRAY, "gray"));
            this.m_colorChooser.addItem(new ColorItem(Color.GREEN, "green"));
            this.m_colorChooser.addItem(new ColorItem(Color.LIGHT_GRAY, "light gray"));
            this.m_colorChooser.addItem(new ColorItem(Color.MAGENTA, "magenta"));
            this.m_colorChooser.addItem(new ColorItem(Color.ORANGE, "orange"));
            this.m_colorChooser.addItem(new ColorItem(Color.PINK, "pink"));
            this.m_colorChooser.addItem(new ColorItem(Color.RED, "red"));
            this.m_colorChooser.addItem(new ColorItem(Color.YELLOW, "yellow"));
            this.m_colorChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    Color color = (Color)((JComboBox)ae.getSource()).getSelectedItem();
                    Showcase.this.getTrace().setColor(color);
                }
            });
            this.m_colorChooser.setSelectedIndex(10);
            this.m_colorChooser.setMaximumSize(new Dimension(200, this.m_clear.getMaximumSize().height));
        }

        private void createLatencySlider() {
            this.m_latencyTimeSlider = new JSlider(10, 210);
            this.m_latencyTimeSlider.setBackground(Color.WHITE);
            this.m_latencyTimeSlider.setValue((int)Showcase.this.getCollector().getLatency());
            this.m_latencyTimeSlider.setMajorTickSpacing(50);
            this.m_latencyTimeSlider.setMinorTickSpacing(10);
            this.m_latencyTimeSlider.setSnapToTicks(true);
            this.m_latencyTimeSlider.setPaintLabels(true);
            this.m_latencyTimeSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Latency for adding points.", 1, 3));
            this.m_latencyTimeSlider.setPaintTicks(true);
            this.m_latencyTimeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        Showcase.this.getCollector().setLatency(value);
                    }
                }
            });
        }

        private void createSnapShotButton() {
            this.m_snapshot = new JButton(Chart2DActionSaveImageSingleton.getInstance(Showcase.this.m_chart, "Save image"));
            this.m_snapshot.setBackground(Color.WHITE);
        }

        private void createStartStopButton() {
            this.m_startStop = new JButton("start");
            this.m_startStop.setBackground(Color.WHITE);
            this.m_startStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JButton source = (JButton)e.getSource();
                    if (Showcase.this.getCollector().isRunning()) {
                        Showcase.this.stopData();
                        source.setText("start");
                    } else {
                        Showcase.this.startData();
                        source.setText("stop");
                    }
                    source.invalidate();
                    source.repaint();
                }
            });
        }
    }
}

