/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.Cursor;
import org.h2.index.TreeIndex;
import org.h2.index.TreeNode;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class TreeCursor
implements Cursor {
    private TreeIndex tree;
    private TreeNode node;
    private boolean beforeFirst;
    private SearchRow first;
    private SearchRow last;

    TreeCursor(TreeIndex treeIndex, TreeNode treeNode, SearchRow searchRow, SearchRow searchRow2) {
        this.tree = treeIndex;
        this.node = treeNode;
        this.first = searchRow;
        this.last = searchRow2;
        this.beforeFirst = true;
    }

    public Row get() {
        return this.node == null ? null : this.node.row;
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public int getPos() {
        return this.node.row.getPos();
    }

    public boolean next() throws SQLException {
        if (this.beforeFirst) {
            this.beforeFirst = false;
            if (this.node == null) {
                return false;
            }
            if (this.first != null && this.tree.compareRows(this.node.row, this.first) < 0) {
                this.node = this.tree.next(this.node);
            }
        } else {
            this.node = this.tree.next(this.node);
        }
        if (this.node != null && this.last != null && this.tree.compareRows(this.node.row, this.last) > 0) {
            this.node = null;
        }
        return this.node != null;
    }

    public boolean previous() {
        this.node = this.tree.previous(this.node);
        return this.node != null;
    }
}

