/**
 * @author <a href="mailto:goran_schwarz@hotmail.com">Goran Schwarz</a>
 */
package asemon;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;

import org.apache.log4j.Logger;

import asemon.cm.CountersModel;
import asemon.gui.ConnectionDialog;
import asemon.gui.MainFrame;
import asemon.gui.SummaryPanel;
import asemon.pcs.InMemoryCounterHandler;
import asemon.pcs.PersistContainer;
import asemon.pcs.PersistentCounterHandler;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.Memory;

public class GetCountersGui
    extends GetCounters
{
	/** Log4j logging. */
	private static Logger _logger          = Logger.getLogger(GetCountersGui.class);

	public GetCountersGui()
	{
	}

	public void init()
	throws Exception
	{
		Configuration tmpConf = Configuration.getInstance(Configuration.TEMP);
//		String propPrefix = "nogui.";
//
//		_props = Asemon.getProps();
//		Configuration saveProps = Asemon.getSaveProps();
//
//		if ( _props == null )
//		{
//			throw new Exception("No configuration was initiated.");
//		}
//
//		// WRITE init message, jupp a little late, but I wanted to grab the _name
//		_logger.info("Initializing the NO-GUI sampler component.");

		// Create all the CM objects, the objects will be added to _CMList
		this.createCounters();


		// Connect ON-STARTUP, use the ConnectionDialog for this, so we do not have
		// to duplicate the logic for this in here as well...
		// WARNING: if logic in ConnectionDialog changes, we might be in trouble
		if ( tmpConf.getBooleanProperty(ConnectionDialog.CONF_OPTION_CONNECT_ON_STARTUP, false) )
		{
			// Use the below info just to write the message of what we THINK the
			// ConnectionDialog will connect us to...
			String host    = tmpConf.getProperty("conn.hostname");
			String port    = tmpConf.getProperty("conn.port");
			String user    = tmpConf.getProperty("conn.username");
			String aseServer = AseConnectionFactory.getServer();
			_logger.info("Connecting ON-STARTUP to host='"+host+"', port='"+port+"', srvName='"+aseServer+"', user='"+user+"'. This by using a non visible ConnectionDialog.");

			MainFrame mf = MainFrame.getInstance();
			if (mf != null)
			{
				mf.action_connect(new ActionEvent(this, 1, ConnectionDialog.CONF_OPTION_CONNECT_ON_STARTUP));
			}
		}
	}

	public void run()
	{
		boolean	  firstLoopAfterConnect = true;
		boolean   canDoReconnect        = false; // means if we have ever been connected to any server, which then means we can do reconnect if we lost the connection
		int       reconnectProblems     = 0;
		Timestamp sessionStartTime      = null;

		// Set the Thread name
		setName("GetCountersGUI");
		_thread = Thread.currentThread();

		// loop
		int loopCounter = 0;

		//---------------------------
		// START the InMemory Counter Handler
		//---------------------------
		InMemoryCounterHandler imch = null;
		try
		{
			imch = new InMemoryCounterHandler();
			imch.init( Configuration.getInstance(Configuration.CONF) );
			InMemoryCounterHandler.setInstance(imch);

			// Register listeners
			imch.addChangeListener(MainFrame.getInstance());

			// Start it
			imch.start();
		}
		catch (Exception e)
		{
			_logger.error("Problems initializing InMemoryCounterHandler,", e);
		}

		//---------------------------
		// NOW LOOP
		//---------------------------
		while (true)
		{
			MainFrame.setStatus(MainFrame.ST_MEMORY);

			// are we in offline read mode
			if ( MainFrame.isOfflineConnected() )
			{
				MainFrame.setStatus(MainFrame.ST_OFFLINE_CONNECT);
				MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Offline read mode, use the offline window to navigate.");

				try { Thread.sleep(500); }
				catch (InterruptedException ignore) {}

				// START AT THE TOP, wait for a CONNECT
				continue;
			}
			// NOT CONNECTED, sleep a little less than the refresh interval
			// this to be more responsive for new connections.
			else if ( ! MainFrame.isMonConnected() )
			{
				firstLoopAfterConnect = true;
				sessionStartTime      = null;

				MainFrame.setStatus(MainFrame.ST_DISCONNECT);
				MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Not connected to any server. Please connect now!");

				try { Thread.sleep(500); }
				catch (InterruptedException ignore) {}

				// maybe do reconnect if the connection has been lost
				if (canDoReconnect)
				{
					Configuration tmpConf = Configuration.getInstance(Configuration.TEMP);
					if ( tmpConf.getBooleanProperty(ConnectionDialog.CONF_OPTION_RECONNECT_ON_FAILURE, false) )
					{
						// Give up after X number of reconnects
						if (reconnectProblems < 100)
						{
							// NOTE: we might have to do:
							//   mf.action_connect(new ActionEvent(this, 1, ConnectionDialog.CONF_OPTION_CONNECT_ON_STARTUP));
							// But for now just try to gram a connection and continue, revisit this later
							try
							{
								Connection conn = AseConnectionFactory.getConnection("master", Version.getAppName());
								MainFrame.setMonConnection(conn);

								String str = AseConnectionFactory.getServer() + " (" +
								             AseConnectionFactory.getHost()   + ":" +
								             AseConnectionFactory.getPort()   + ")";

								_logger.info("Re-connected to monitored server '"+str+"' after a 'lost connection'.");
								reconnectProblems = 0;
							}
							catch (Exception e)
							{
								reconnectProblems++;
								_logger.warn("Problem when re-connecting to monitored server. Caught: "+e);
								MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Re-connect FAILED, I will soon try again.");

								// On connect failure sleep for a little longer
								try { Thread.sleep(5000); }
								catch (InterruptedException ignore) {}
							}
						}
					}

				}

				// START AT THE TOP, wait for a CONNECT
				continue;
			}

			// set a flag that we have been connected, which means that we can try to do
			// re-connect if we lost the connection
			if (MainFrame.isMonConnected())
			{
				canDoReconnect = true;
			}

			loopCounter++;

			// When 10 MB of memory or less, write some info about that.
			Memory.checkMemoryUsage(10);

			try
			{
				// Sleep (if not first loop)
				if ( ! firstLoopAfterConnect )
				{
					int sleepTime = MainFrame.getRefreshInterval();
					for (int i=sleepTime; i>0; i--)
					{
						if (MainFrame.getStatus(MainFrame.ST_STATUS_FIELD).startsWith("Sleeping for "))
							MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Sleeping for "+i+" seconds, waiting for "+getWaitEvent());

						// Update Watermarks on all the CM tabs
						Iterator iter = _CMList.iterator();
						while (iter.hasNext())
						{
							CountersModel cm = (CountersModel) iter.next();
							if (cm == null)
								continue;

							if ( cm.getTabPanel() != null)
								cm.getTabPanel().setWatermark();
						}

						// Now SLEEP
						try { Thread.sleep(1000); }
						catch (InterruptedException ignore)
						{
							// leave the sleep loop
							break;
						}
					} // end: sleep loop
				}
				firstLoopAfterConnect = false;

				if ( ! refreshCntr )
					continue;


				// Initialize the counters, now when we know what
				// know we are connected to
				if ( ! initialized )
				{
					initCounters(
						MainFrame.getMonConnection(),
						MonTablesDictionary.getInstance().aseVersionNum,
						MonTablesDictionary.getInstance().montablesVersionNum);

					// emulate a slow INIT time...
					//try { Thread.sleep(7000); }
					//catch (InterruptedException ignore) {}
				}

				//----------------------
				// In some versions we need to do some checks before we refresh the counters
				// - 15.0.3 ESD#1, 15.0.3.ESD#2, 15.0.3.ESD#3
				//   if: sp_configure 'capture missing statistics' is true, then the sysstatistics table in
				//       the master database will be updated on mon* tables, so the transaction log might get full
				// CR# 581760
				// "capture missing statistics" will capture statistics for MDA Tables
				// http://www-dse/cgi-bin/websql/websql.dir/QTS/bugsheet.hts?GO=GO&bugid=581760
				//----------------------
				// TODO: move this block into GetCounters.java
				//       - also call it from GetCounterNoGui
				try
				{
					if (    MonTablesDictionary.getInstance().aseVersionNum >= 15031 && MonTablesDictionary.getInstance().aseVersionNum <= 15033
						 || MonTablesDictionary.getInstance().aseVersionNum >= 15500 && MonTablesDictionary.getInstance().aseVersionNum <= 15501
					   )
					{
						Connection conn = MainFrame.getMonConnection();
						boolean captureMissingStatistics =AseConnectionUtils.getAseConfigRunValueBooleanNoEx(conn, "capture missing statistics");
						if (captureMissingStatistics)
						{
							_logger.debug("Checking for full transaction log in the master database.");

							String sql = "select 'isLoggFull' = lct_admin('logfull', db_id('master'))," +
							             "       'spaceLeft'  = lct_admin('logsegment_freepages', db_id('master')) " +      // Describes the free space available for a database
							             "                    - lct_admin('reserve', 0) " +                                 // Returns the current last-chance threshold of the transaction log in the database from which the command was issued
							             "                    - lct_admin('reserved_for_rollbacks', db_id('master'), 0) " + // Determines the number of pages reserved for rollbacks in the master database
							             "                    - @@thresh_hysteresis";                                       // Take away hysteresis

							int isLogFull = 0;
							int spaceLeft = 0;

							Statement stmt = conn.createStatement();
							ResultSet rs = stmt.executeQuery(sql);
							while (rs.next())
							{
								isLogFull   = rs.getInt(1);
								spaceLeft   = rs.getInt(2);
							}
							rs.close();
							stmt.close();

							_logger.debug("Checking for full transaction log in the master database. Results: isLogFull='"+isLogFull+"', spaceLeft='"+spaceLeft+"'.");

							if (isLogFull > 0  ||  spaceLeft <= 0)
							{
								_logger.warn("Truncating the transaction log in the master database. Issuing SQL 'dump tran master with truncate_only'. isLogFull='"+isLogFull+"', spaceLeft='"+spaceLeft+"'.");
								stmt = conn.createStatement();
								stmt.execute("dump tran master with truncate_only");
								stmt.close();
							}
						}
					}
				}
				catch (SQLException e)
				{
					_logger.warn("When checking for a full transaction log in master, we got problem, but skipping this problem and continuing.", e);
				}

				refreshing = true;
				Component comp = MainFrame.getActiveTab();
				MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Refreshing...");


				// Get the CounterStorage if we have any
				PersistentCounterHandler pcs = PersistentCounterHandler.getInstance();

				// Get session/head info
				String    aseServerName    = null;
				Timestamp mainSampleTime   = null;
				Timestamp counterClearTime = null;

				Statement stmt = MainFrame.getMonConnection().createStatement();
				ResultSet rs = stmt.executeQuery("select getdate(), @@servername, CountersCleared from master..monState");
				while (rs.next())
				{
					mainSampleTime   = rs.getTimestamp(1);
					aseServerName    = rs.getString(2);
					counterClearTime = rs.getTimestamp(3);
				}
				rs.close();
				stmt.close();

				// SET a session id and call startSession()
				if (sessionStartTime == null)
				{
					sessionStartTime = mainSampleTime;
					if (pcs != null)
					{
						PersistContainer tmpPc = new PersistContainer(sessionStartTime, mainSampleTime, aseServerName);
						Iterator iter = _CMList.iterator();
						while (iter.hasNext())
						{
							CountersModel cm = (CountersModel) iter.next();
							if (cm == null) continue;
							if ( ! cm.isActive() ) continue;
							tmpPc.add(cm);
						}
						pcs.startSession(tmpPc);
					}
				}

				// PCS
				PersistContainer pc = null;
				if (pcs != null || imch != null)
					pc = new PersistContainer(sessionStartTime, mainSampleTime, aseServerName);

				//-----------------
				// Update data in tabs
				//-----------------

				// LOOP all CounterModels, and get new data,
				//   if it should be done
				Iterator iter = _CMList.iterator();
				while (iter.hasNext())
				{
					CountersModel cm = (CountersModel) iter.next();

					if (cm == null)
					{
						_logger.info("CountersModel: IS NULL.");
						continue;
					}

					if ( cm.getTabPanel() != null)
					{
						if (pcs == null)
							cm.getTabPanel().enableOptionPersistCounters(false);
						else
							cm.getTabPanel().enableOptionPersistCounters(true);
					}

//					if ( ! cm.isSwingRefreshOK())
//						continue;

					if ( ! cm.isActive() )
						continue;

					//-------------------------------------
					// SHOULD WE REFRESH OR NOT
					//-------------------------------------
					boolean refresh = false;

//TODO: move below check for shouldRefresh() into a method inside CM...
// this removed the hardcoded check for CMsummary and other individual stuff...
					// Always for Summary
					if (cm.getName().equals(SummaryPanel.CM_NAME))
						refresh = true;

					// Current TAB is visible
					if ( cm.equalsTabPanel(comp) )
						refresh = true;

					// Current CM has active graphs
					if ( cm.hasActiveGraphs() )
						refresh = true;

					// Background poll is checked
					if ( cm.isBackgroundDataPollingEnabled() )
						refresh = true;

					// Store data in DB && we have storage
					if ( cm.isPersistCountersEnabled() && pcs != null)
						refresh = true;

					// NO-REFRESH if data polling is PAUSED
					if ( cm.isDataPollingPaused() )
						refresh = false;

					// REFRESH THE COUNTERS NOW
					if (refresh)
					{
						cm.setServerName(aseServerName);
						cm.setSampleTimeHead(mainSampleTime);
						cm.setCounterClearTime(counterClearTime);

						cm.refresh();

						// move this into cm.refresh()
						cm.setValidSampleData(true); 

						// Add the CM to the container, which will
						// be posted to persister thread later.
						if ( (pc != null && cm.isPersistCountersEnabled()) || imch != null )
							pc.add(cm);
					}
					else
					{
						// move this into cm.shouldRefresh()
						cm.setValidSampleData(false); 
					}

					// Post processing if it's the Summary
// this is now done by listeners, which was setup in GetCounters when adding/creating CMsummary
//					if (cm.getName().equals(SummaryPanel.CM_NAME))
//					{
//						MainFrame.setSummaryData(cm);
//					}

					cm.endOfRefresh();
				}

				// POST the container to the Persistent Counter Handler
				// That thread will store the information in any Storage.
				if (pcs != null)
					pcs.add(pc);

				// POST/Add to the history queue
				if (imch != null)
					imch.add(pc);


				//-----------------
				// Update SUMMARY GRAPHS
				//-----------------
				MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Refreshing... Graphs...");

				_logger.debug("---- Refreshing... Graphs... ----");
				iter = _CMList.iterator();
				while (iter.hasNext())
				{
					CountersModel cm = (CountersModel) iter.next();

					if (cm != null)
					{
						// the background thread needs to complete
//						cm.waitForSwingDataRefresh();

//						if (cm.isSwingRefreshOK())
//						{
							// Post processing if it's the Summary
							if ( cm.hasActiveGraphs() )
							{
								cm.updateGraphs();
							}
//						}
//						else
//							_logger.debug(getName()+"cm.isSwingRefreshOK() == FALSE");

					}
				}

				refreshing = false;
				setWaitEvent("next sample period...");
				MainFrame.setStatus(MainFrame.ST_STATUS_FIELD, "Sleeping for "+MainFrame.getRefreshInterval()+" seconds.");
			}
//			catch (org.jfree.data.SeriesException jfsex)
//			{
//				//_logger.debug("asemon : error in GetCounters loop. "+jfsex);
//				refreshing = false;
//			}
			catch (Exception e)
			{
				//        System.out.println("asemon : error in GetCounters loop. "+e);
				_logger.error("asemon : error in GetCounters loop ("+e.getMessage()+").", e);
				refreshing = false;
				//System.exit(1);
			}
		}
	}
}
