/**
 * @author <a href="mailto:goran_schwarz@hotmail.com">Goran Schwarz</a>
 */
package asemon.gui.wizard;


import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

import javax.swing.UIManager;

import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;

import asemon.Asemon;
import asemon.utils.Configuration;

public class WizardOffline
{
    private static final long serialVersionUID = 1L;
//	private Map	             _settings;
//	private WizardController _controller;

	protected static final String MigLayoutHelpConstraints = "wmin 100, span, growx, gapbottom 15, wrap";
	protected static final String MigLayoutConstraints1 = "";
	protected static final String MigLayoutConstraints2 = "[] [grow] []";
	protected static final String MigLayoutConstraints3 = "";
	
	protected static final Dimension preferredSize = new Dimension(400, 300);
	
	public WizardOffline()
	{
		System.clearProperty("wizard.sidebar.image");
		System.setProperty("wizard.sidebar.image", "asemon/gui/wizard/WizardOffline.png");

//		BufferedImage img = ImageIO.read (getClass().getResource ("WizardOffline.png"));
//		UIManager.put ("wizard.sidebar.image", img);

		Class[] wca = { 
				WizardOfflinePage1.class,
				WizardOfflinePage2.class,
				WizardOfflinePage3.class,
				WizardOfflinePage4.class,
				WizardOfflinePage5.class
				};
		Wizard wiz = WizardPage.createWizard("Create an offline sample session.", wca, new WizardOffllinePageSummary());
		
		Map gatheredSettings = (Map) WizardDisplayer.showWizard(wiz);
//		System.out.println("gatheredSettings="+gatheredSettings);
		try {
			finish(gatheredSettings);
		} catch (WizardException e) {
			e.printStackTrace();
		}

		System.clearProperty("wizard.sidebar.image");
	}

	

    protected Object finish(Map settings) throws WizardException
	{
    	Configuration offlineProps = new Configuration();
		Configuration aseMonProps = Configuration.getInstance(Configuration.CONF);
    	
		offlineProps.setFilename((String)settings.get("storeFile"));
		offlineProps.setEmbeddedMessage("File generated by Offline Wizard.");
		//offlineProps.save();

		//Process some props for PCS functionality, or change name in WizardPanel?
		String changeKey = "jdbcDriver";
		settings.put("PersistWriterJdbc." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "jdbcUrl";
		settings.put("PersistWriterJdbc." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "jdbcUsername";
		settings.put("PersistWriterJdbc." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "jdbcPassword";
		settings.put("PersistWriterJdbc." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		
		changeKey        = "aseHost";
		settings.put("conn." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "aseName";
		settings.put("conn." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "asePassword";
		settings.put("conn." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "asePort";
		settings.put("conn." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "aseUsername";
		settings.put("conn." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		
		changeKey        = "sampleTime";
		settings.put("offline." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);
		changeKey        = "storeFile";
		settings.put("offline." + changeKey , settings.get(changeKey));
		settings.remove(changeKey);

		//Add the PCS Writer, or add it as a wizard property?
		String writerClass = aseMonProps.getProperty("PersistentCounterHandler.WriterClass");
		if(writerClass == null)
			writerClass = "asemon.pcs.PersistWriterJdbc";
		settings.put("PersistentCounterHandler.WriterClass", writerClass);
		
//		settings.put("CM.sysMon.test", "testtest");
		
		for (Iterator iterator = settings.keySet().iterator(); iterator.hasNext();)
		{
			String key = (String) iterator.next();
			String val = (String) settings.get(key);
			
			if(key.indexOf('.') == -1)
			{
				offlineProps.put("CM." + key + ".sample", val);
				if(getUDCConfigName(key) != null)
				{
					String udcPrefix = "udc." + getUDCConfigName(key);
					Enumeration enumL1 = aseMonProps.getKeys(udcPrefix);
					while(enumL1.hasMoreElements())
					{
						String udcKey = (String) enumL1.nextElement();
						String udcVal = aseMonProps.getProperty(udcKey);
						offlineProps.put(udcKey, udcVal);
					}
				}
			}
			else
				offlineProps.put(key, val);
		}
		offlineProps.save();
		
		//Really you would construct some object or do something with the
		//contents of the map
		return settings;
	}
    
    private String getUDCConfigName(String name)
    {
    	String        udcConfigName  = null;
    	String        udcPrefix      = "udc.";
		Configuration aseMonProps = Configuration.getInstance(Configuration.CONF);
    	
		Enumeration enumL1 = aseMonProps.getKeys(udcPrefix);
		while(enumL1.hasMoreElements())
		{
			String udcKey = (String) enumL1.nextElement();
			String udcName = udcKey.substring(udcPrefix.length(), udcKey.indexOf(".", udcPrefix.length()));
			if(udcKey.equals(udcPrefix + name + ".name"))
			{
				udcConfigName = udcName;
				return udcConfigName;
			}
			
		}
		return udcConfigName;
    }
    
	public static void main(String[] args)
	{
    	try 
    	{
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    		//UIManager.setLookAndFeel(new SubstanceOfficeSilver2007LookAndFeel());
		} 
    	catch (Exception e) 
		{
			e.printStackTrace();
		}
    	new WizardOffline();
//    	WizardOffline provider = new WizardOffline();
//		Wizard wizard = provider.createWizard();
//		Object result = WizardDisplayer.showWizard(wizard);
	}

}

